﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Autodesk.Revit.UI;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI.Selection;

namespace InterfaceStudy {
    [Autodesk.Revit.Attributes.Transaction(Autodesk.Revit.Attributes.TransactionMode.Manual)]
    public class Command : IExternalCommand {

        public Result Execute(ExternalCommandData commandData, ref string message, ElementSet elementSet) {

            try {

                //Create local values
                mCommandData = commandData;
                mLocalForms = new LocalForms(commandData);
                mLocalForms.CreateForm("DialogTest");

                //Example with direct call to sub menu.                
                System.Windows.Forms.MessageBox.Show("Case 1: Direct Call to Dialog.");
                bool displayForm = true;
                while (displayForm) {
                    if (mLocalForms.DialogTestForm == null) mLocalForms.DialogTestForm = new DialogTest(commandData);
                    mLocalForms.DialogTestForm.ShowDialog();
                    if (mLocalForms.DialogTestForm.CommandToLaunch == "") {
                        displayForm = false;
                    }
                    else {
                        mLocalForms.DialogTestForm.LaunchCommand();
                        if (mLocalForms.DialogTestForm.AutoClose) displayForm = false;
                    }
                }

                //Example with Parent Menu Form.
                System.Windows.Forms.MessageBox.Show("Case 2: Call to Dialog from Parent Menu Form.");
                mCommandData = commandData;              
                Menu menu = null;                
                string childFormName = "";
                bool displayMenuForm = true;
                while (displayMenuForm) {
                    if (menu == null) {
                        menu = new Menu(commandData);
                        menu.ShowDialog();
                        if (menu.ChildForm == null) break;  //User never made a selection and pressed close button
                        childFormName = menu.ChildForm.Name;
                        mLocalForms.AssignChildToLocalForm(menu.ChildForm);
                    }
                    else {
                        mLocalForms.AssignChildToLocalForm(menu.ShowChildFormByName(childFormName));
                    }
                    menu.AutoClose = (bool)mLocalForms.GetAutoCloseValue(childFormName);
                    if (menu.CommandToLaunch == "") displayMenuForm = false;
                    else {
                        mLocalForms.LaunchDialogCommand(menu.ChildForm);
                        if (menu.AutoClose) displayMenuForm = false;
                    }
                   
                }
                return Result.Succeeded;
            }
            catch (Exception exception) {
                message = exception.Message;
                return Result.Failed;
            }
        }

        private ExternalCommandData mCommandData;
        private LocalForms mLocalForms;

    } //Command Class

    // ****************************************************************************************************************************************
    // ************************************************************ LocalForms Class **********************************************************
    // ****************************************************************************************************************************************

    public class LocalForms {

        public DialogTest DialogTestForm { set; get; }
        //Etc. for additional subforms.       

        public LocalForms(ExternalCommandData commandData) {
            mCommandData = commandData;
        }

        public void CreateForm(string nameForm) {
            switch (nameForm) {
                case "DialogTest":
                    DialogTestForm = new DialogTest(mCommandData);
                    break;
                //Etc. for additional subforms.
            }
        }

        public void AssignChildToLocalForm(System.Windows.Forms.Form childForm) {
            switch (childForm.Name) {
                case "DialogTest":
                    DialogTestForm = (DialogTest)childForm;
                    break;
                //Etc. for additional subforms.
            }
        }

        public bool? GetAutoCloseValue(string nameForm) {
            switch (nameForm) {
                case "DialogTest":
                    return DialogTestForm.AutoClose;
                //Etc. for additional subforms.
                default:
                    return null;
            }
        }

        public void LaunchDialogCommand(System.Windows.Forms.Form childForm) {
            switch (childForm.Name) {
                case "DialogTest":
                    DialogTest dialogTest = (DialogTest)childForm;
                    dialogTest.LaunchCommand();
                    break;
                //Etc. for additional subforms.
            }
        }

        private ExternalCommandData mCommandData;
    }


} //Namespace

