﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;

using Autodesk.Revit.UI;
using Autodesk.Revit.DB;

using Autodesk.Revit.UI.Selection;

namespace InterfaceStudy {
    public partial class DialogTest : System.Windows.Forms.Form {

        public string CommandToLaunch { get; set; }
        public void LaunchCommand() {
            switch (CommandToLaunch) {
                case "":                                 break;  //Do nothing
                case "SelectSingle":   SelectSingle();   break;
                case "SelectMultiple": SelectMultiple(); break;
            }
            CommandToLaunch = "";
        }
        public bool AutoClose {
            get { return checkBoxAutoClose.Checked; }
            set { checkBoxAutoClose.Checked = value; }
        }

        private UIApplication mUiApplication;
        private UIDocument mUiDocument;
        private Document mDocument;
        private SelectionFilter mSelectionFilter;

        public DialogTest(ExternalCommandData commandData) {
            InitializeComponent();
            mUiApplication = commandData.Application;
            mUiDocument = mUiApplication.ActiveUIDocument;
            mDocument = mUiDocument.Document;
            mSelectionFilter = new SelectionFilter();
            checkBoxAutoClose.Checked = false;
            CommandToLaunch = "";
            radioButtonDoors.Checked = true;
            SetFilter();
        }

        public bool SelectMultiple() {
            try {
                IList<Element> elementsFiltered = mUiDocument.Selection.PickElementsByRectangle(mSelectionFilter, "Select elements with a window.  ESC to cancel.");
                foreach (Element element in elementsFiltered) {
                    Transaction transaction = new Transaction(mDocument, "EditMultiple");
                    transaction.Start();
                    mDocument.Delete(element);
                    transaction.Commit();
                }
                return true;
            }
            catch {
                return false;
            }
        }

        public bool SelectSingle() {
            try {
                while (true) {
                    try {
                        Reference reference = mUiDocument.Selection.PickObject(ObjectType.Element, mSelectionFilter, "Select single element.  ESC to cancel.");
                        Element element = mDocument.get_Element(reference.ElementId);
                        Transaction transaction = new Transaction(mDocument, "EditSingle");
                        transaction.Start();
                        mDocument.Delete(element);
                        transaction.Commit();
                    }
                    catch {   //Escape or right-click-Cancel ends loop
                        break;
                    }
                }
                return true;
            }
            catch {
                return false;
            }
        }

        private void buttonWindow_Click(object sender, EventArgs e) {
            CommandToLaunch = "SelectMultiple";
            Close();
        }

        private void buttonSingle_Click(object sender, EventArgs e) {
            CommandToLaunch = "SelectSingle";
            Close();
        }

        private void SetFilter() {
            if (radioButtonDoors.Checked) mSelectionFilter.FilterCategory = "Doors";
            else mSelectionFilter.FilterCategory = "Windows";
        }

        private void radioButtonDoors_CheckedChanged(object sender, EventArgs e) {
            SetFilter();
        }

        private void radioButtonWindows_CheckedChanged(object sender, EventArgs e) {
            //Not needed since implicit in radioButtonDoors_CheckedChanged
        }

    }


    // ******************************************************************************************************************
    // ***************************************** Selection Filter Class *************************************************
    // ******************************************************************************************************************

    public class SelectionFilter : ISelectionFilter {
        public string FilterCategory { set; get; }
        public bool AllowElement(Element element) {
            return (element.Category.Name == FilterCategory);
        }
        public bool AllowReference(Reference refer, XYZ point) {
            return true;
        }
        private void GetValues() {
        }
    }
}
