﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
//using System.Windows.Forms;

using Autodesk.Revit.UI;
using Autodesk.Revit.DB;

namespace InterfaceStudy {
    public partial class Menu : System.Windows.Forms.Form {

        public System.Windows.Forms.Form ChildForm { get; set; }
        public string CommandToLaunch { get; set; }
        public bool AutoClose { get; set; }


        private DialogTest dialogTest;

        private ExternalCommandData mCommandData;

        public Menu(ExternalCommandData commandData) {
            InitializeComponent();
            mCommandData = commandData;
            CommandToLaunch = "";
        }


        public System.Windows.Forms.Form ShowChildFormByName(string formName) {
            switch (formName) {
                case "DialogTest":
                    if (dialogTest == null) {
                        dialogTest = new DialogTest(mCommandData);
                        ChildForm = dialogTest;
                    }

                    dialogTest.ShowDialog(this);
                    CommandToLaunch = dialogTest.CommandToLaunch;
                    AutoClose = dialogTest.AutoClose;
                    return ChildForm;
                default:
                    return null;
            }
        }

        private void buttonRunDialogTest_Click(object sender, EventArgs e) {
            ShowChildFormByName("DialogTest");
            Close();
        }
    }
}
