﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Autodesk.Revit;
using Autodesk.Revit.Elements;
using System.Windows.Forms;
using Excel = Microsoft.Office.Interop.Excel;

namespace AddMaterials
{
  public class Command : IExternalCommand
  {
    public IExternalCommand.Result Execute(
      ExternalCommandData revit,
      ref string message,
      ElementSet elements )
    {
      m_app = revit.Application;
      m_doc = revit.Application.ActiveDocument;
      fillPatterns = m_doc.Settings.FillPatterns;

      xlApp = new Excel.ApplicationClass();
      xlApp.Visible = false;

      try
      {
        xlWorkBook = xlApp.Workbooks.Open( 
          @"C:\RevitAPI\MaterialList.xlsx", 0, true, 5, "", "", true, 
          Microsoft.Office.Interop.Excel.XlPlatform.xlWindows, 
          "\t", false, false, 0, true, 1, 0 );

        xlWorkSheet = ( Excel.Worksheet ) xlWorkBook.Worksheets.get_Item( 1 );

        range = xlWorkSheet.UsedRange;

        while( ( range.Cells[rCnt, 1] as Excel.Range ).Value2 != null )
        {
          string matName = ( string ) ( range.Cells[rCnt, 1] as Excel.Range ).Value2;
          matName += " " + ( string ) ( range.Cells[rCnt, 2] as Excel.Range ).Value2;
          matName += " " + ( string ) ( range.Cells[rCnt, 3] as Excel.Range ).Value2;

          double red = ( double ) ( range.Cells[rCnt, 4] as Excel.Range ).Value2;
          double green = ( double ) ( range.Cells[rCnt, 5] as Excel.Range ).Value2;
          double blue = ( double ) ( range.Cells[rCnt, 6] as Excel.Range ).Value2;
          double transparency = ( double ) ( range.Cells[rCnt, 8] as Excel.Range ).Value2;
          string surPattern = ( string ) ( range.Cells[rCnt, 9] as Excel.Range ).Value2;
          string cutPattern = ( string ) ( range.Cells[rCnt, 10] as Excel.Range ).Value2;

          if( matName != null )
          {
            string CSI = ( string ) ( range.Cells[rCnt, 11] as Excel.Range ).Value2;
            if( m_doc.Settings.Materials.Contains( CSI ) )
            {
              Material materialCSI = m_doc.Settings.Materials.get_Item( CSI ); //which contains identity data with material class for filter.
              Material myMaterial = materialCSI.Duplicate( matName );

              Color matColor = new Color();
              matColor.Red = Byte.Parse( red.ToString() );
              matColor.Green = Byte.Parse( green.ToString() );
              matColor.Blue = Byte.Parse( blue.ToString() );

              myMaterial.Color = matColor;
              myMaterial.Transparency = ( int ) transparency;
              foreach( FillPattern fillPattern in fillPatterns )
              {
                if( fillPattern.Name == surPattern )
                {
                  myMaterial.SurfacePattern = fillPattern;
                }
                if( fillPattern.Name == cutPattern )
                {
                  myMaterial.CutPattern = fillPattern;
                }
              }
            }

            // MaterialOther myMaterial = m_doc.Settings.Materials.AddOther(matName);
          }
          rCnt++;
        }
        xlWorkBook.Close( true, null, null );
        xlApp.Quit();

        MessageBox.Show( "material added successfully!", 
          "Revit AddMaterials" );
      }
      catch( Exception ex )
      {
        MessageBox.Show( "Exception: " + ex.ToString(),
          "Revit AddMaterials" );
      }
      return IExternalCommand.Result.Succeeded;
    }

    #region Basic Command Data
    private Autodesk.Revit.Application m_app;
    private Autodesk.Revit.Document m_doc;
    private Excel.Application xlApp;
    private Excel.Workbook xlWorkBook;
    private Excel.Worksheet xlWorkSheet;
    private Excel.Range range;
    private FillPatternSet fillPatterns;

    private int rCnt = 5;
    #endregion
  }
}
