﻿using System;
using System.Diagnostics;
using Autodesk.Revit;
using Autodesk.Windows; // RibbonTab class
using RibbonPanel = Autodesk.Windows.RibbonPanel; // ambiguous, exists in Autodesk.Revit as well as Autodesk.Windows

namespace AddRibbonTab
{
  public class AdskCommandHandler
    : System.Windows.Input.ICommand
  {
    string AssemblyName
    {
      get;
      set;
    }

    string ClassName
    {
      get;
      set;
    }

    public AdskCommandHandler(
      string assemblyName,
      string className )
    {
      AssemblyName = assemblyName;
      ClassName = className;
    }

    public event EventHandler CanExecuteChanged;

    public bool CanExecute( object a )
    {
      return true;
    }

    public void Execute( object a )
    {
      System.Reflection.Assembly assembly
        = System.Reflection.Assembly.LoadFrom(
          AssemblyName );

      IExternalCommand command
        = assembly.CreateInstance(
          ClassName ) as IExternalCommand;

      Debug.Print(
        "AdskCommandHandler.Execute command invoked: "
        + "assembly {0}, class {1}",
        AssemblyName, ClassName );

      ExternalCommandData commandData = null;
      string message = string.Empty;
      ElementSet elements = null;

      IExternalCommand.Result r 
        = command.Execute( commandData, 
          ref message, elements );
    }
  }

  /// <summary>
  /// External application which defines a custom ribbon tab.
  /// </summary>
  public class App : IExternalApplication
  {
    public IExternalApplication.Result OnStartup( 
      ControlledApplication a )
    {
      // create new ribbon button:

      RibbonButton button = new RibbonButton();
      button.Text = "My Button";
      button.ShowText = true;
      button.CommandHandler = new AdskCommandHandler(
        "AddRibbonTab.dll", "AddRibbonTab.Command" );

      // create new ribbon panel:

      RibbonPanelSource source = new RibbonPanelSource();
      source.Title = "My Panel";
      source.Items.Add( button );

      RibbonPanel panel = new RibbonPanel();
      panel.Source = source;

      // create custom ribbon tab:

      RibbonTab tab = new RibbonTab();
      tab.Id = "MY_TAB_ID";
      tab.Title = "My Custom Tab";
      tab.IsVisible = true;

      // access Revit ribbon control and add custom tab:

      RibbonControl control
        = UIFramework.RevitRibbonControl.RibbonControl;

      control.Tabs.Add( tab );
      tab.Panels.Add( panel );

      /*
      // prepare to change a contextual tab

      control.Tabs.CollectionChanged 
        += new System.Collections.Specialized
          .NotifyCollectionChangedEventHandler( 
          tabs_CollectionChanged );
      */

      return IExternalApplication.Result.Succeeded;
    }

    public IExternalApplication.Result OnShutdown(
      ControlledApplication a )
    {
      return IExternalApplication.Result.Succeeded;
    }

    /*
    void tabs_CollectionChanged( 
      object sender, 
      System.Collections.Specialized.NotifyCollectionChangedEventArgs e )
    {
      if( e.Action 
        == System.Collections.Specialized.NotifyCollectionChangedAction.Add )
      {
        foreach( Object o in e.NewItems )
        {
          UIFramework.RvtRibbonTab tab = o as UIFramework.RvtRibbonTab;
        
          if( tab != null )
          {
            if( tab.Title.Equals( "Modify Walls" ) )
            {
              tab.Panels.Add( CreateMyPanel() );
            }
          }
        }
      }
    }
    */

  }
}
