﻿#region Namespaces
using System;
using System.Collections.Generic;
using System.Reflection;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
#endregion

namespace AecMatInfoAppRevit
{
  class App : IExternalApplication
  {
    const string _classNamePrefix = "Cmd";
    static string [] cmdNames = new string[] { "Store", "Retrieve" };
    static char[] _separator = new char[] { '.' };

    public Result OnStartup( UIControlledApplication a )
    {
      string path 
        = Assembly.GetExecutingAssembly().Location;

      string classNameFullPrefix 
        = GetType().FullName.Split( _separator )[0] 
        + "." 
        + _classNamePrefix;

      RibbonPanel rp = a.CreateRibbonPanel( "AEC Material Information" );

      for( int i = 0; i < 2; ++i )
      {
        string cmd = cmdNames[i];

        PushButtonData d = new PushButtonData( cmd, 
          cmd, path, classNameFullPrefix + cmd );

        d.ToolTip = cmd + " cloud data";

        rp.AddItem( d );
      }
      return Result.Succeeded;
    }

    public Result OnShutdown( UIControlledApplication a )
    {
      return Result.Succeeded;
    }
  }
}
