﻿using System.ServiceModel;

namespace AecMatInfoClientCmdLine
{
  class Program
  {
    static AecInfoServiceClient _aecSvrClnt = null; // AEC Database
    static MfgInfoServiceClient _mfgSvrClnt = null; // MFG Database

    static void InitialiseServiceClients()
    {
      if( null == _aecSvrClnt || null == _mfgSvrClnt )
      {
        System.ServiceModel.Channels.Binding binding = new BasicHttpBinding();

        if( null == _aecSvrClnt )
        {
          EndpointAddress endpointAddressAec = new EndpointAddress(
            "http://adnmonitor.cloudapp.net/AecInfoService.svc?wsdl" );

          _aecSvrClnt = new AecInfoServiceClient( binding, endpointAddressAec );
        }

        if( null == _mfgSvrClnt )
        {
          EndpointAddress endpointAddressMfg = new EndpointAddress(
            "http://adnmonitor.cloudapp.net/MfgInfoService.svc?wsdl" );

          _mfgSvrClnt = new MfgInfoServiceClient( binding, endpointAddressMfg );
        }
      }
    }

    static void Main( string[] args )
    {
      InitialiseServiceClients();

      string matName = "Wood for Jeremy";
      string matSpec = "Really hard wood";
      string matUnit = "m^3";
      string region = "Switzerland";
      float cost = 150;

      // Update AEC Database
      _aecSvrClnt.UpdateAecMaterialInfo( matName, matSpec, matUnit, region, cost );

      // Update MFG Database
      _mfgSvrClnt.UpdateMfgMaterialInfo( matName, matSpec, matUnit, region, cost );

      // Get the cost per unit from AEC Database
      double cost2 = _aecSvrClnt.GetCostPerUnit( matName, matSpec, matUnit, region );

      // Get the cost per unit from MFG Database
      cost2 = _mfgSvrClnt.GetCostPerUnit( matName, matSpec, matUnit, region );
    }
  }
}

// web service paths:
// 
// http://adnmonitor.cloudapp.net/aecinfoservice.svc
// http://adnmonitor.cloudapp.net/mfginfoservice.svc
// 
// see database tables data in browser:
// 
// http://gthelloazure.cloudapp.net/aecmaterialinfo.aspx
// http://gthelloazure.cloudapp.net/mfgmaterialinfo.aspx
