﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.ServiceModel;

namespace AecMatInfoClientRevit
{
  public partial class ManageAecDataForm : Form
  {
    AecInfoServiceClient aecSvrClnt; // For AEC Database
    MfgInfoServiceClient mfgSvrClnt; // For MFG Database

    public ManageAecDataForm()
    {
      InitializeComponent();

      System.ServiceModel.Channels.Binding binding = new BasicHttpBinding();

      // For AEC Database

      EndpointAddress endpointAddressAec = new EndpointAddress(
        "http://adnmonitor.cloudapp.net/AecInfoService.svc?wsdl" );

      aecSvrClnt = new AecInfoServiceClient( binding, endpointAddressAec );

      // For MFG Database
      //
      EndpointAddress endpointAddressMfg = new EndpointAddress( 
        "http://adnmonitor.cloudapp.net/MfgInfoService.svc?wsdl" );
      
      mfgSvrClnt = new MfgInfoServiceClient( binding, endpointAddressMfg );
    }

    private void uploadButton_Click( object sender, EventArgs e )
    {
      if( 0 < matNameBox.Text.Length
        && 0 < matSpecBox.Text.Length
        && 0 < matUnitBox.Text.Length
        && 0 < regionBox.Text.Length
        && 0 < costBox.Text.Length )
      {
        float cost = float.Parse( costBox.Text );
        
        // Update AEC Database
        aecSvrClnt.UpdateAecMaterialInfo(matNameBox.Text, matSpecBox.Text, matUnitBox.Text, regionBox.Text, cost);

        // Update MFG Database
        //mfgSvrClnt.UpdateMfgMaterialInfo( matNameBox.Text, matSpecBox.Text, matUnitBox.Text, regionBox.Text, cost );
      }
    }

    private void getButton_Click( object sender, EventArgs e )
    {
      if( 0 < matNameBox.Text.Length
        && 0 < matSpecBox.Text.Length
        && 0 < matUnitBox.Text.Length
        && 0 < regionBox.Text.Length )
      {
        // Get the cost per unit from AEC Database
        double cost = aecSvrClnt.GetCostPerUnit(matNameBox.Text, matSpecBox.Text, matUnitBox.Text, regionBox.Text);
        
        // Get the cost per unit from MFG Database
        //double cost = mfgSvrClnt.GetCostPerUnit( matNameBox.Text, matSpecBox.Text, matUnitBox.Text, regionBox.Text );
        
        costBox.Text = cost.ToString();
      }
    }
  }
}
