﻿using System;
using System.Diagnostics;
using Autodesk.Revit;
using Autodesk.Revit.Events;
using WinForms = System.Windows.Forms;

namespace AutoConfirmSave
{
  public class App : IExternalApplication
  {
    public IExternalApplication.Result OnShutdown( 
      ControlledApplication a )
    {
      a.DialogBoxShowing
        -= new EventHandler<DialogBoxShowingEventArgs>(
          a_DialogBoxShowing );
      return IExternalApplication.Result.Succeeded;
    }

    public IExternalApplication.Result OnStartup( 
      ControlledApplication a )
    {
      a.DialogBoxShowing 
        += new EventHandler<DialogBoxShowingEventArgs>( 
          a_DialogBoxShowing );
      return IExternalApplication.Result.Succeeded;
    }

    void a_DialogBoxShowing( 
      object sender, 
      DialogBoxShowingEventArgs e )
    {
      TaskDialogShowingEventArgs e2 
        = e as TaskDialogShowingEventArgs;

      string s = string.Empty;
      
      if( null != e2 )
      {
        s = string.Format( 
          ", dialog id {0}, message '{1}'", 
          e2.DialogId, e2.Message );

        bool isConfirm = e2.DialogId.Equals( 
          "TaskDialog_Save_File" );

        if ( isConfirm )
        {
          e2.OverrideResult( 
            (int) WinForms.DialogResult.Yes );

          s += ", auto-confirmed.";
        }
      }

      Debug.Print( 
        "DialogBoxShowing: help id {0}, cancellable {1}{2}",
        e.HelpId,
        e.Cancellable ? "Yes" : "No",
        s );
    }
  }
}
