﻿using System;
using System.Diagnostics;
//using WinForms = System.Windows.Forms;
using Autodesk.Revit;
using Autodesk.Revit.Events;

namespace AutoExecuteOnOpen
{
  public class App : IExternalApplication
  {
    public IExternalApplication.Result OnStartup(
      ControlledApplication a )
    {
      a.DocumentCreated 
        += new EventHandler<DocumentCreatedEventArgs>( 
          a_DocumentCreated );

      a.DocumentOpened 
        += new EventHandler<DocumentOpenedEventArgs>( 
          a_DocumentOpened );

      return IExternalApplication.Result.Succeeded;
    }

    public IExternalApplication.Result OnShutdown(
      ControlledApplication a )
    {
      a.DocumentCreated
        -= new EventHandler<DocumentCreatedEventArgs>(
          a_DocumentCreated );

      a.DocumentOpened
        -= new EventHandler<DocumentOpenedEventArgs>(
          a_DocumentOpened );

      return IExternalApplication.Result.Succeeded;
    }

    //const string _caption = "AutoExecuteOnOpen";

    void a_DocumentCreated( object sender, Autodesk.Revit.Events.DocumentCreatedEventArgs e )
    {
      //WinForms.MessageBox.Show( "DocumentCreated", _caption ); // no input accepted to click OK when driven from journal file in Visual Studio debugger
      Debug.Print( "DocumentCreated" );
    }

    void a_DocumentOpened( object sender, DocumentOpenedEventArgs e )
    {
      //WinForms.MessageBox.Show( "DocumentOpened", _caption ); // no input accepted to click OK when driven from journal file in Visual Studio debugger
      Debug.Print( "DocumentOpened" );
    }
  }
}
