﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace AutoPDFPrint_Bridge.CS
{
    class Methods
    {
        /*------------------------------------------------------------------------------------**/
        /// <summary>
        /// Get the current time HH:mm:ss
        /// </summary>
        /// <returns> string </returns>
        /// <author>Dan.Tartaglia </author>                              <date>04/2010</date>
        /*--------------+---------------+---------------+---------------+---------------+------*/
        public string TimeCurrentGet(string strDivider)
        {
            return System.DateTime.Now.ToString("HH" + strDivider + "mm" + strDivider + "ss");
        }

        /*------------------------------------------------------------------------------------**/
        /// <summary>
        /// Get the current date yymmdd
        /// </summary>
        /// <returns> string </returns>
        /// <author>Dan.Tartaglia </author>                              <date>04/2010</date>
        /*--------------+---------------+---------------+---------------+---------------+------*/
        public string DateCurrentGet()
        {
            string strCountryCode = "";
            try
            {
                // Get the name of the current country
                string strCountry = System.Globalization.RegionInfo.CurrentRegion.EnglishName;

                // Set the country code as needed
                switch (strCountry)
                {
                    case "United States":
                        strCountryCode = "en-US";
                        break;

                    case "United Kingdom":
                        strCountryCode = "en-GB";
                        break;

                    case "People's Republic of China":
                        strCountryCode = "zh-CN";
                        break;

                    default:
                        strCountryCode = "en-US";
                        break;
                }

                // Get the current date
                string strDate = (DateTime.Now.ToString("yyyyMMdd",
                    System.Globalization.CultureInfo.GetCultureInfo(strCountryCode)));

                // Verify the string has enough chars to process
                if (strDate.Length == 8)
                    return strDate.Substring(2, 6);
                else
                    return "";
            }
            catch
            {
                return "";
            }
        }

        /*------------------------------------------------------------------------------------**/
        /// <summary>
        /// Write to the output text file
        /// </summary>
        /// <returns> void </returns>
        /// <author>Dan.Tartaglia </author>                              <date>01/2013</date>
        /*--------------+---------------+---------------+---------------+---------------+------*/
        public void TextFileWrite(string strTextFileName, string strValue, bool blnAppend)
        {
            try
            {
                // create a writer and open the file
                TextWriter tw = new StreamWriter(strTextFileName, blnAppend);

                // Add a line of text to the output file
                tw.WriteLine(strValue);

                // close the stream
                tw.Close();
            }
            catch
            {
            }
        }

        /*------------------------------------------------------------------------------------**/
        /// <summary>
        /// Launch Revit Architecture
        /// </summary>
        /// <returns> true or false </returns>
        /// <author>Dan.Tartaglia </author>                              <date>01/2013</date>
        /*--------------+---------------+---------------+---------------+---------------+------*/
        public bool RevitArchLaunch(string strVersion)
        {
            DefaultValues oDefaultValues = new DefaultValues();

            try
            {
                // Verify the Revit.exe exists
                if (File.Exists(@"C:\Program Files\Autodesk\Revit Architecture " + strVersion + @"\Revit.exe") == true)
                {
                    // Launch Revit
                    System.Diagnostics.Process.Start(@"C:\Program Files\Autodesk\Revit Architecture " + strVersion +
                        @"\Revit.exe");
                }
                else
                    return false;
            }
            catch
            {
                return false;
            }
            return true;
        }
    }
}
