﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace AutoPDFPrint_Bridge.CS
{
    class Program
    {
        public static string strLogfileFullPath = string.Empty;

        static void Main(string[] args)
        {
            DefaultValues oDefaultValues = new DefaultValues();
            Methods oMethods = new Methods();

            try
            {
                // Get the start date/time
                string strProcessDate = oMethods.DateCurrentGet();

                // Log file full path
                strLogfileFullPath = oDefaultValues.strLogFilePath + strProcessDate + ".log";

                // Create the log folder if needed
                if (Directory.Exists(oDefaultValues.strLogFilePath) == false)
                    Directory.CreateDirectory(oDefaultValues.strLogFilePath);

                //args = new string[1];
                //args[0] = "100XXX.00 - My Project.cfg";

                if (args.Count() != 1)
                {
                    // Write to log file
                    oMethods.TextFileWrite(strLogfileFullPath, "Please specify the CFG file name in the Task Scheduler Action's Add argument field: " +
                        oMethods.DateCurrentGet() + "-" + oMethods.TimeCurrentGet(":") + ", Printing Aborted", true);

                    return;
                }

                // CFG name
                string strPrintCFG = args[0].ToString();

                // Verify the CFG file is found
                if (File.Exists(oDefaultValues.strScriptFilePath + strPrintCFG) == false)
                {
                    // Write to log file
                    oMethods.TextFileWrite(strLogfileFullPath, "CFG file not found: '" + oDefaultValues.strScriptFilePath +
                        strPrintCFG + "': " + oMethods.DateCurrentGet() + "-" + oMethods.TimeCurrentGet(":") +
                        ", Printing Aborted", true);

                    return;
                }

                // Create the temp folder if needed
                if (Directory.Exists(oDefaultValues.strTempPrintPath) == false)
                    Directory.CreateDirectory(oDefaultValues.strTempPrintPath);

                // Copy the CFG file into the temp folder
                File.Copy(oDefaultValues.strScriptFilePath + strPrintCFG, oDefaultValues.strTempPrintPath +
                    strPrintCFG, true);

                if (oMethods.RevitArchLaunch(oDefaultValues.strRevitVersion) == false)
                {
                    // Write to log file
                    oMethods.TextFileWrite(strLogfileFullPath, "Could not launch Revit " + oDefaultValues.strRevitVersion + ": " +
                        oMethods.DateCurrentGet() + "-" + oMethods.TimeCurrentGet(":") + ", Printing Aborted", true);
                }
            }
            catch(Exception ex)
            {
                // Write to log file
                oMethods.TextFileWrite(strLogfileFullPath, "Error: '" + ex.Message + " : " +
                    oMethods.DateCurrentGet() + "-" + oMethods.TimeCurrentGet(":") +
                    ", Printing Aborted", true);
            }
        }
    }
}
