﻿#Region "Imported Namespaces"

'.NET common used namespaces
Imports System
Imports System.Windows.Forms
Imports System.Collections.Generic

'Revit.NET common used namespaces
Imports Autodesk.Revit.ApplicationServices
Imports Autodesk.Revit.Attributes
Imports Autodesk.Revit.DB
Imports Autodesk.Revit.UI
Imports Autodesk.Revit.UI.Selection

#End Region

<Transaction(TransactionMode.Automatic)> _
<Regeneration(RegenerationOption.Manual)> _
Public Class Commands
    Implements IExternalCommand

    Dim _oRvtDoc As Document

    'This function works fine

    Private Function oGetFrontView(ByVal oElem As Autodesk.Revit.DB.Element) As ViewSection

        Dim oBBox As BoundingBoxXYZ = oElem.BoundingBox(Nothing) 'get the bbox of the element

        'get the size of the box
        Dim oW As Double = (oBBox.Max.X - oBBox.Min.X)
        Dim oD As Double = (oBBox.Max.Y - oBBox.Min.Y)
        Dim oH As Double = (oBBox.Max.Z - oBBox.Min.Z)

        'from front
        Dim oMaxPt As XYZ = New XYZ(-oW / 2, oH / 2, oD / 2)
        Dim oMinPt As XYZ = New XYZ(oW / 2, -oH / 2, -oD / 2 - 0.2) ' small gap between section and element

        Dim oBBoxView As New BoundingBoxXYZ
        oBBoxView.Enabled = True
        oBBoxView.Max = oMaxPt
        oBBoxView.Min = oMinPt

        'set the transform
        Dim oTrans As Transform = Transform.Identity

        'find the midpoint of the element
        Dim oMidPt As XYZ = New XYZ((oBBox.Max.X + oBBox.Min.X) / 2.0, (oBBox.Max.Y + oBBox.Min.Y) / 2.0, (oBBox.Max.Z + oBBox.Min.Z) / 2.0)

        'set it as origin
        oTrans.Origin = oMidPt

        'now direction
        Dim oDirZ As XYZ = New XYZ(0.0, 1.0, 0.0)
        Dim oDirX As XYZ = New XYZ(-1.0, 0.0, 0.0)
        Dim oDirY As XYZ = New XYZ(0.0, 0.0, 1.0)

        oTrans.BasisX = oDirX
        oTrans.BasisY = oDirY
        oTrans.BasisZ = oDirZ

        oBBoxView.Transform = oTrans

        'create a sectionview and return it
        Return _oRvtDoc.Create.NewViewSection(oBBoxView)

    End Function


    'The created section is placed on the front side. The view direction seems okay.

    Private Function oGetBackView(ByVal oElem As Autodesk.Revit.DB.Element) As ViewSection

        Dim oBBox As BoundingBoxXYZ = oElem.BoundingBox(Nothing) 'get the bbox of the element

        'get the size of the box
        Dim oW As Double = (oBBox.Max.X - oBBox.Min.X)
        Dim oD As Double = (oBBox.Max.Y - oBBox.Min.Y)
        Dim oH As Double = (oBBox.Max.Z - oBBox.Min.Z)

        'from behind
        Dim oMaxPt As XYZ = New XYZ(oW / 2, oH / 2, oD / 2)
        Dim oMinPt As XYZ = New XYZ(-oW / 2, -oH / 2, -oD / 2 - 0.2) ' small gap between section and element

        Dim oBBoxView As New BoundingBoxXYZ
        oBBoxView.Enabled = True
        oBBoxView.Max = -oMaxPt
        oBBoxView.Min = -oMinPt

        'set the transform
        Dim oTrans As Transform = Transform.Identity

        ''find the midpoint of the element
        Dim oMidPt As XYZ = New XYZ((oBBox.Max.X + oBBox.Min.X) / 2.0, (oBBox.Max.Y + oBBox.Min.Y) / 2.0, (oBBox.Max.Z + oBBox.Min.Z) / 2.0)

        'set it as origin
        oTrans.Origin = oMidPt

        'now direction
        Dim oDirZ As XYZ = New XYZ(0.0, 1.0, 0.0)
        Dim oDirX As XYZ = New XYZ(1.0, 0.0, 0.0)
        Dim oDirY As XYZ = New XYZ(0.0, 0.0, -1.0)

        oTrans.BasisX = oDirX
        oTrans.BasisY = oDirY
        oTrans.BasisZ = oDirZ

        oBBoxView.Transform = oTrans

        'create a sectionview and return it
        Return _oRvtDoc.Create.NewViewSection(oBBoxView)

    End Function


    ''' <summary>
    ''' The one and only method required by the IExternalCommand interface, the main entry point for every external command.
    ''' </summary>
    ''' <param name="commandData">Input argument providing access to the Revit application and its documents and their properties.</param>
    ''' <param name="message">Return argument to display a message to the user in case of error if Result is not Succeeded.</param>
    ''' <param name="elements">Return argument to highlight elements on the graphics screen if Result is not Succeeded.</param>
    ''' <returns>Cancelled, Failed or Succeeded Result code.</returns>
    Public Function Execute(ByVal commandData As ExternalCommandData, _
                            ByRef message As String, _
                            ByVal elements As ElementSet) As Result Implements IExternalCommand.Execute
        'TODO: Add your code here


        'Must return some code
        Return Result.Succeeded
    End Function
End Class
