﻿using System;
using System.Collections.Generic;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.Electrical;
using Autodesk.Revit.UI;

namespace JtCableTray
{
  [Transaction(TransactionMode.Automatic)]
  [Regeneration(RegenerationOption.Automatic)]

  public class ClsCableTray : IExternalCommand
  {
    public Result Execute(
      ExternalCommandData commandData, 
      ref string message, 
      ElementSet elements)
    {
      try
      {
        UIApplication app = commandData.Application;
        UIDocument uidoc = app.ActiveUIDocument;
        Document doc = uidoc.Document;

        ElementId idType = new ElementId( 411325 );
        ElementId idLevel = new ElementId( 311 );

        XYZ start1 = new XYZ( -30.498257567, 38.420015690, 10.058014598 );
        XYZ end1 = new XYZ( -20.435555001, 30.837225417, 10.058014598 );
        CableTray tray1 = CableTray.Create( doc, idType, start1, end1, idLevel );

        XYZ start2 = new XYZ( -20.435555001, 30.837225417, 10.058014598 );
        XYZ end2 = new XYZ( -20.435555001, 30.837225417, 13.338854493 );
        CableTray tray2 = CableTray.Create( doc, idType, start2, end2, idLevel );

        XYZ start3 = new XYZ( -20.435555001, 30.837225417, 13.338854493 );
        XYZ end3 = new XYZ( -11.525321413, 24.122882809, 13.338854493 );
        CableTray tray3 = CableTray.Create( doc, idType, start3, end3, idLevel );

        XYZ start4 = new XYZ( -11.525321413, 24.122882809, 13.338854493 );
        XYZ end4 = new XYZ( -11.525321413, 24.122882809, 10.058014598 );
        CableTray tray4 = CableTray.Create( doc, idType, start4, end4, idLevel );

        XYZ start5 = new XYZ( -11.525321413, 24.122882809, 10.058014598 );
        XYZ end5 = new XYZ( -2.001326892, 16.946038164, 10.058014598 );
        CableTray tray5 = CableTray.Create( doc, idType, start5, end5, idLevel );


        Connector c1start, c1end = null;

        foreach( Connector c in tray1.ConnectorManager.Connectors )
        {
          if( c.Origin.IsAlmostEqualTo( start1 ) )
          {
            c1start = c;
          }
          else if( c.Origin.IsAlmostEqualTo( end1 ) )
          {
            c1end = c;
          }
        }

        Connector c2start = null, c2end;

        foreach( Connector c in tray2.ConnectorManager.Connectors )
        {
          if( c.Origin.IsAlmostEqualTo( start2 ) )
          {
            c2start = c;
          }
          else if( c.Origin.IsAlmostEqualTo( end2 ) )
          {
            c2end = c;
          }
        }

        if( null != c1end && null != c2start )
        {
          c1end.ConnectTo( c2start );

          // this throws
          // Autodesk.Revit.Exceptions.InvalidOperationException: 
          // "failed to insert elbow":

          doc.Create.NewElbowFitting( c1end, c2start );
        }

        return Result.Succeeded;
      }
      catch( Exception ex )
      {
        message = ex.Message;
        return Result.Failed;
      }
    }
  }
}
