#region Namespaces
using System;
using System.Collections.Generic;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.DB.Events;
#endregion

namespace CancelFamilyCreation
{
  class App : IExternalApplication
  {
    void OnDocumentCreating(
      object sender,
      DocumentCreatingEventArgs e )
    {
      DocumentType typ = e.DocumentType;

      if( DocumentType.Family == typ )
      {
        TaskDialog d = new TaskDialog( 
          "Open Family Editor?" );

        d.MainInstruction = "Creating a new family "
          + "document... would you like to proceed?";

        d.MainContent = string.Format( 
          "Document type: {0}\r\nCancellable: {1}",
          typ, (e.Cancellable ? "Yes" : "No") );

        d.CommonButtons = TaskDialogCommonButtons.Yes 
          | TaskDialogCommonButtons.No;

        d.DefaultButton = TaskDialogResult.No;

        if( TaskDialogResult.No == d.Show() )
        {
          e.Cancel();
        }
      }
    }

    public Result OnStartup( 
      UIControlledApplication a )
    {
      a.ControlledApplication.DocumentCreating 
        += new EventHandler<DocumentCreatingEventArgs>( 
          OnDocumentCreating );

      return Result.Succeeded;
    }

    public Result OnShutdown( UIControlledApplication a )
    {
      return Result.Succeeded;
    }
  }
}
