﻿#region Namespaces
using System;
using System.Collections.Generic;
using System.Linq;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
#endregion

namespace CreateFloors
{
  [Transaction( TransactionMode.Manual )]
  public class Command : IExternalCommand
  {
    public Result Execute(
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      UIApplication uiapp = commandData.Application;
      UIDocument uidoc = uiapp.ActiveUIDocument;
      Application app = uiapp.Application;
      Document doc = uidoc.Document;

      FilteredElementCollector levels 
        = new FilteredElementCollector( doc )
          .OfClass( typeof( Level ) );

      FloorType floorType
        = new FilteredElementCollector( doc )
          .OfClass( typeof( FloorType ) )
          .First<Element>( 
            e => e.Name.Equals( "Generic - 12\"" ) ) 
            as FloorType;

      Element profileElement
        = new FilteredElementCollector( doc )
          .OfClass( typeof( FamilyInstance ) )
          .OfCategory( BuiltInCategory.OST_GenericModel )
          .First<Element>(
            e => e.Name.Equals( "WP1" ) );

      CurveArray slabCurves = new CurveArray();

      GeometryElement geo = profileElement.get_Geometry( new Options() );

      foreach( GeometryInstance inst in geo.Objects )
      {
        foreach( GeometryObject obj in inst.SymbolGeometry.Objects )
        {
          if( obj is Curve )
          {
            slabCurves.Append( obj as Curve );
          }
        }
      }

      XYZ normal = XYZ.BasisZ;

      Transaction trans = new Transaction( doc );
      trans.Start( "Create Floors" );

      foreach( Level level in levels )
      {
        Floor newFloor = doc.Create.NewFloor( slabCurves, floorType, level, false, normal );

        newFloor.get_Parameter( BuiltInParameter.FLOOR_HEIGHTABOVELEVEL_PARAM ).Set( 0 );
      }

      trans.Commit();

      return Result.Succeeded;
    }
  }
}
