#region Namespaces
using System;
using System.Collections.Generic;
using System.Linq;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
#endregion

namespace CreateFloorPlan
{
  [Transaction( TransactionMode.Manual )]
  public class Command : IExternalCommand
  {
    /// <summary>
    /// Create FloorPlan for Level using NewViewPlan
    /// </summary>
    public Level CreateLevelOld(
      Document doc,
      double elevation,
      string name )
    {
      Autodesk.Revit.Creation.Document createdoc
        = doc.Create;

      Level level = createdoc.NewLevel( elevation );
      level.Name = name;
      ElementId nid = level.Id;

      createdoc.NewViewPlan( name, level,
        ViewPlanType.FloorPlan );

      return level;
    }

    /// <summary>
    /// Create FloorPlan for Level using ViewPlan.Create
    /// </summary>
    public Level CreateLevel(
      Document doc,
      double elevation,
      string name )
    {
      Level level = doc.Create.NewLevel( elevation );
      level.Name = name;
      ElementId nid = level.Id;

      IEnumerable<ViewFamilyType> viewFamilyTypes
        = from elem in new FilteredElementCollector( doc )
            .OfClass( typeof( ViewFamilyType ) )
          let type = elem as ViewFamilyType
          where type.ViewFamily == ViewFamily.FloorPlan
          select type;

      ViewPlan floorPlan = ViewPlan.Create( doc,
        viewFamilyTypes.First().Id, nid );

      return level;
    }


    public Result Execute(
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      UIApplication uiapp = commandData.Application;
      UIDocument uidoc = uiapp.ActiveUIDocument;
      Document doc = uidoc.Document;

      using( Transaction tx = new Transaction( doc ) )
      {
        tx.Start( "Create Floor Plan" );

        Autodesk.Revit.Creation.Document createdoc
          = doc.Create;

        string name = "Findus";

        // Create Level

        double elevation = 10;
        Level level = createdoc.NewLevel( elevation );
        level.Name = name;
        ElementId nid = level.Id;

        bool use_obsolete_code = false;

        if( use_obsolete_code )
        {
          // Create FloorPlan for the 
          // Level using NewViewPlan

          createdoc.NewViewPlan( name, level,
            ViewPlanType.FloorPlan );
        }
        else
        {
          // Create FloorPlan for the 
          // Level using ViewPlan.Create

          ViewFamilyType vft
            = new FilteredElementCollector( doc )
              .OfClass( typeof( ViewFamilyType ) )
              .Cast<ViewFamilyType>()
              .FirstOrDefault<ViewFamilyType>( x =>
                ViewFamily.StructuralPlan == x.ViewFamily );

          ViewPlan floorPlan = ViewPlan.Create(
            doc, vft.Id, nid );

          //floorPlan.Discipline 
          //  = ViewDiscipline.Structural;
        }
        tx.Commit();
      }
      return Result.Succeeded;
    }
  }
}
