﻿Imports Autodesk.Revit.DB

Public Class ElementsVisibleInViewExportContext
   Implements IExportContext

   Private Documents As New Stack(Of Document)
   Private Property Elements As New Dictionary(Of String, HashSet(Of ElementId))

   Public ReadOnly Property ElementVisible(doc As Document, id As ElementId) As Boolean
      Get

         Dim ids As HashSet(Of ElementId)

         If Elements.TryGetValue(doc.PathName, ids) Then
            If ids.Contains(id) Then

               Return True

            End If
         End If

         Return False

      End Get
   End Property

   Public Sub New(mainDocument As Document)

      Documents.Push(mainDocument)
      Elements.Add(mainDocument.PathName, New HashSet(Of ElementId))

   End Sub

   Public Function Start() As Boolean Implements Autodesk.Revit.DB.IExportContext.Start

      Return True

   End Function
   Public Sub Finish() Implements Autodesk.Revit.DB.IExportContext.Finish

      'Nothing.

   End Sub

   Public Function OnViewBegin(node As Autodesk.Revit.DB.ViewNode) As Autodesk.Revit.DB.RenderNodeAction Implements Autodesk.Revit.DB.IExportContext.OnViewBegin

      Return RenderNodeAction.Proceed

   End Function
   Public Sub OnViewEnd(elementId As Autodesk.Revit.DB.ElementId) Implements Autodesk.Revit.DB.IExportContext.OnViewEnd

      'Nothing.

   End Sub

   Public Function OnLinkBegin(node As Autodesk.Revit.DB.LinkNode) As Autodesk.Revit.DB.RenderNodeAction Implements Autodesk.Revit.DB.IExportContext.OnLinkBegin

      Dim doc = node.GetDocument

      Documents.Push(doc)
      If Not Elements.ContainsKey(doc.PathName) Then Elements.Add(doc.PathName, New HashSet(Of ElementId))

      Return RenderNodeAction.Proceed

   End Function
   Public Sub OnLinkEnd(node As Autodesk.Revit.DB.LinkNode) Implements Autodesk.Revit.DB.IExportContext.OnLinkEnd

      Dim doc = Documents.Pop()

   End Sub

   Public Function OnElementBegin(elementId As Autodesk.Revit.DB.ElementId) As Autodesk.Revit.DB.RenderNodeAction Implements Autodesk.Revit.DB.IExportContext.OnElementBegin

      Elements(Documents.Peek.PathName).Add(elementId)

      Return RenderNodeAction.Skip

   End Function
   Public Sub OnElementEnd(elementId As Autodesk.Revit.DB.ElementId) Implements Autodesk.Revit.DB.IExportContext.OnElementEnd

      'Nothing.

   End Sub

   Public Function OnInstanceBegin(node As Autodesk.Revit.DB.InstanceNode) As Autodesk.Revit.DB.RenderNodeAction Implements Autodesk.Revit.DB.IExportContext.OnInstanceBegin

      Return RenderNodeAction.Skip

   End Function
   Public Sub OnInstanceEnd(node As Autodesk.Revit.DB.InstanceNode) Implements Autodesk.Revit.DB.IExportContext.OnInstanceEnd

      'Nothing.

   End Sub

   Public Function OnFaceBegin(node As Autodesk.Revit.DB.FaceNode) As Autodesk.Revit.DB.RenderNodeAction Implements Autodesk.Revit.DB.IExportContext.OnFaceBegin

      Return RenderNodeAction.Skip

   End Function
   Public Sub OnFaceEnd(node As Autodesk.Revit.DB.FaceNode) Implements Autodesk.Revit.DB.IExportContext.OnFaceEnd

      'Nothing.

   End Sub

   Public Sub OnMaterial(node As Autodesk.Revit.DB.MaterialNode) Implements Autodesk.Revit.DB.IExportContext.OnMaterial

      'Nothing.

   End Sub
   Public Sub OnPolymesh(node As Autodesk.Revit.DB.PolymeshTopology) Implements Autodesk.Revit.DB.IExportContext.OnPolymesh

      'Nothing.

   End Sub
   Public Sub OnRPC(node As Autodesk.Revit.DB.RPCNode) Implements Autodesk.Revit.DB.IExportContext.OnRPC

      'Nothing.

   End Sub

   Public Sub OnDaylightPortal(node As Autodesk.Revit.DB.DaylightPortalNode) Implements Autodesk.Revit.DB.IExportContext.OnDaylightPortal

      'Nothing.

   End Sub
   Public Sub OnLight(node As Autodesk.Revit.DB.LightNode) Implements Autodesk.Revit.DB.IExportContext.OnLight

      'Nothing.

   End Sub

   Public Function IsCanceled() As Boolean Implements Autodesk.Revit.DB.IExportContext.IsCanceled

      Return False

   End Function

End Class