﻿using System;
using System.IO;
using System.Text;
using System.Collections.Generic;

using Autodesk.Revit.DB;
using Autodesk.Revit.Utility;

namespace CustomExporterXml
{
  /// <summary>
  /// Miscellaneous conversion (to a string) utilities
  /// </summary>
  class StringConversions
  {
    internal static String ValueToString( Transform t )
    {
      if( t == Transform.Identity )
      {
        return "(1,0,0)(0,1,0)(0,0,1)(0,0,0)";
      }

      StringBuilder sb = new StringBuilder( 150 );
      sb.Append( t.BasisX.ToString() );
      sb.Append( t.BasisY.ToString() );
      sb.Append( t.BasisZ.ToString() );
      sb.Append( t.Origin.ToString() );
      return sb.ToString();
    }

    internal static String ValueToString( IList<float> values )
    {
      StringBuilder sb = new StringBuilder( 15 * values.Count );
      bool first = true;
      foreach( float item in values )
      {
        if( !first )
        {
          sb.Append( "," );
          first = false;
        }
        sb.Append( item.ToString() );
      }
      return sb.ToString();
    }

    internal static String ValueToString( IList<XYZ> Points )
    {
      StringBuilder sb = new StringBuilder( 45 * Points.Count );
      foreach( XYZ point in Points )
      {
        sb.Append( point.ToString() );
      }
      return sb.ToString();
    }

    internal static String ValueToString( IList<UV> Points )
    {
      StringBuilder sb = new StringBuilder( 30 * Points.Count );
      foreach( UV point in Points )
      {
        sb.Append( point.ToString() );
      }
      return sb.ToString();
    }

    internal static String ValueToString( DoubleArray doubles )
    {
      StringBuilder sb = new StringBuilder( 20 * doubles.Size );
      if( doubles.Size > 0 )
      {
        sb.Append( doubles.get_Item( 0 ).ToString() );
        for( int idx = 1; idx < doubles.Size; idx++ )
        {
          sb.Append( "," );
          sb.Append( doubles.get_Item( idx ).ToString() );
        }
      }
      return sb.ToString();
    }

    internal static String ValueToString( IList<PolymeshFacet> facets )
    {
      StringBuilder sb = new StringBuilder( 12 * facets.Count );
      foreach( PolymeshFacet facet in facets )
      {
        sb.Append( facet.ToString() );
      }
      return sb.ToString();
    }
  }
}
