#region Namespaces

using System;
using System.Collections.Generic;
using System.Diagnostics;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.Events;
using Autodesk.Revit.UI;
using Autodesk.Revit.DB.ExtensibleStorage;
#endregion

namespace DataStorageSample
{
  class App : IExternalApplication
  {
    public Result OnStartup( 
      UIControlledApplication a )
    {
      a.ControlledApplication.DocumentCreated 
        += AppDocumentCreated;

      return Result.Succeeded;
    }

    private void AppDocumentCreated( 
      object sender, 
      DocumentCreatedEventArgs e )
    {
      if( e.Status != RevitAPIEventStatus.Succeeded ) 
        return;

      var doc = e.Document;

      try
      {
        using( Transaction t = new Transaction( 
          doc, "Create created info" ) )
        {
          t.Start();

          // Create data storage in new document

          DataStorage createdInfoStorage 
            = DataStorage.Create( doc );

          // Create entity which store created info

          Entity entity = new Entity( 
            CreatedInfoSchema.GetSchema() );

          entity.Set( "CreatedUser", 
            Environment.UserName );

          entity.Set( "CreatedDate", 
            DateTime.Now.ToString() );

          // Set entity to the data storage element

          createdInfoStorage.SetEntity( entity );

          t.Commit();
        }
      }
      catch( Exception ex )
      {
        Debug.WriteLine( ex.ToString() );
      }
    }

    public Result OnShutdown( 
      UIControlledApplication a )
    {
      a.ControlledApplication.DocumentCreated 
        -= AppDocumentCreated;

      return Result.Succeeded;
    }
  }
}
