#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;
using Autodesk.Revit.DB.ExtensibleStorage;
#endregion

namespace DataStorageSample
{
  [Transaction( TransactionMode.Manual )]
  public class Command : IExternalCommand
  {
    public Result Execute(
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      UIApplication uiapp = commandData.Application;
      UIDocument uidoc = uiapp.ActiveUIDocument;
      Application app = uiapp.Application;
      Document doc = uidoc.Document;

      // Retrieve data storage

      FilteredElementCollector collector =
          new FilteredElementCollector( doc );

      var dataStorage =
          collector
          .OfClass( typeof( DataStorage ) )
          .FirstElement();

      if( dataStorage == null )
      {
        message = "No data storage found "
          + "in current project";

        return Result.Failed;
      }

      // Retrieve entity from the data storage

      Entity createdInfoEntity = dataStorage.GetEntity( 
        CreatedInfoSchema.GetSchema() );

      if( !createdInfoEntity.IsValid() )
      {
        message = "Data storage doesn't "
          + "have CreatedInfoSchema";

        return Result.Failed;
      }

      var createdUser = createdInfoEntity.Get<string>( 
        "CreatedUser" );

      var createdDate = createdInfoEntity.Get<string>( 
        "CreatedDate" );

      StringBuilder sb = new StringBuilder();

      sb.AppendFormat( "Created user: {0}\r\n", 
        createdUser );

      sb.AppendFormat( "Created date: {0}", 
        createdDate );

      TaskDialog.Show( "Project created info", 
        sb.ToString() );

      return Result.Succeeded;
    }
  }
}
