using System;
using Autodesk.Revit.DB.ExtensibleStorage;

namespace DataStorageSample
{
  static class CreatedInfoSchema
  {
    static readonly Guid schemaGuid = new Guid( "{5FAF80CB-901C-4B25-83A7-98FDD2017FB8}" );

    public static Schema GetSchema()
    {
      // looking for existing schema
      Schema schema = Schema.Lookup( schemaGuid );
      if( schema != null )
        return schema;

      //If schema doesn't exists
      //create new schema

      SchemaBuilder schemaBuilder =
          new SchemaBuilder( schemaGuid );
      schemaBuilder.SetSchemaName( "CreatedInfo" );

      schemaBuilder.AddSimpleField( "CreatedUser", typeof( String ) );
      schemaBuilder.AddSimpleField( "CreatedDate", typeof( String ) );

      return schemaBuilder.Finish();
    }
  }
}