using System;
using System.Text;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;

namespace DataStorageSample2
{
  [Transaction( TransactionMode.Manual )]
  public class ReadWriteSettingsCommand : IExternalCommand
  {
    public Result Execute(
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      Document doc = commandData.Application
        .ActiveUIDocument.Document;

      MyProjectSettings settings 
        = new MyProjectSettings();

      settings.Parameter1 = new Random().Next();

      settings.Parameter2 = doc.PathName;

      MyProjectSettingStorage settingStorage 
        = new MyProjectSettingStorage();

      using( Transaction t = new Transaction( 
        doc, "Write settings" ) )
      {
        t.Start();
        settingStorage.WriteSettings( doc, settings );
        t.Commit();
      }

      MyProjectSettings readSettings 
        = settingStorage.ReadSettings( doc );

      if( readSettings == null )
      {
        message = "Could not get settings";
        return Result.Failed;
      }

      StringBuilder sb = new StringBuilder();

      sb.AppendFormat( "Parameter1: {0}\r\n", 
        readSettings.Parameter1 );

      sb.AppendFormat( "Parameter2: {0}\r\n", 
        readSettings.Parameter2 );

      TaskDialog.Show( "Settings", sb.ToString() );

      return Result.Succeeded;
    }
  }
}
