using System;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.ExtensibleStorage;

namespace DataStorageSample2
{
  static class SectionSchema
  {
    static readonly Guid schemaGuid = new Guid( 
      "{720474CF-F59A-43C3-BD60-F5C45DE04C08}" );

    public static Schema GetSchema()
    {
      Schema schema = Schema.Lookup( schemaGuid );

      if( null != schema )
      {

        SchemaBuilder schemaBuilder 
          = new SchemaBuilder( schemaGuid );

        schemaBuilder.SetSchemaName( "Section" );

        schemaBuilder.AddSimpleField( 
          "Name", typeof( string ) );

        schemaBuilder.AddSimpleField( 
          "BoundingBoxMin", 
          typeof( XYZ ) ).SetUnitType( 
            UnitType.UT_Custom );

        schemaBuilder.AddSimpleField( 
          "BoundingBoxMax", 
          typeof( XYZ ) ).SetUnitType( 
            UnitType.UT_Custom );

        schemaBuilder.AddSimpleField( 
          "ViewId", 
          typeof( ElementId ) );

        schema = schemaBuilder.Finish();
      }
      return schema;
    }
  }
}