﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.Threading;

using System.IO;
using System.Reflection;

using System.Runtime.InteropServices;

using System.Diagnostics;

// fuer die ribbons
using System.Windows.Forms.Integration;
using System.Windows.Interop;
using Microsoft.Win32;

// wpf-access
using System.Windows.Automation;

namespace DrivingRevitViaUIAutomation
{
    public partial class Form1 : Form
    {
      #region Blog post sample code
#if INCLUDE_SAMPLE_CODE
      void g()
      {
        PropertyCondition nameOpenDlgCondition 
          = new PropertyCondition( 
            AutomationElement.NameProperty, 
            "Öffnen" ); // en-US: "Open"

        AndCondition andOpenDlgCondition 
          = new AndCondition( nameOpenDlgCondition, 
            typeOpenDlgCondition );

        Thread.Sleep( 600 );

        AutomationElementCollection allOpenDlgs 
          = mainWndFromHandle.FindAll( 
            TreeScope.Children, 
            nameOpenDlgCondition );

        //typeOpenDlgCondition andOpenDlgCondition

        foreach( AutomationElement openOpenDlgWnd 
          in allOpenDlgs )
        {
          if( openOpenDlgWnd.Current.LocalizedControlType 
            == "Dialogfeld" ) // en-US: ?
          {
          }
        }
      }

      private void OpenRevitFile( string filePath )
      {
        // get the Revit 'R' button in the upper left corner
        // FindWindowEx has been imported via P/Invoke
        IntPtr startButtonHandle = FindWindowEx( 
          IntPtr.Zero, IntPtr.Zero, "AdApplicationButton", 
          "AdApplicationButton" );

        if( startButtonHandle != IntPtr.Zero )
        {
          // SendMessage has been imported via P/Invoke

          SendMessage( startButtonHandle, WM_LBUTTONDOWN, 
            IntPtr.Zero, IntPtr.Zero ); // click

          SendMessage( startButtonHandle, WM_LBUTTONUP, 
            IntPtr.Zero, IntPtr.Zero ); // release

          // these lines should be known
          
          Process[] processes = Process.GetProcessesByName( 
            "Revit" );

          WindowHandle _hWndRevit = null;

          if( 0 < processes.Length )
          {
            IntPtr h = processes[0].MainWindowHandle;

            _hWndRevit = new WindowHandle( h );
          }
          if( _hWndRevit != null )
          {
            // revit window
            AutomationElement mainWndFromHandle 
              = AutomationElement.FromHandle( 
                _hWndRevit.Handle );

            // start menu

            PropertyCondition idMenuCondition 
              = new PropertyCondition( 
                AutomationElement.AutomationIdProperty, 
                "Id_ApplicationMenuWindow" );

            AutomationElement menuWnd 
              = mainWndFromHandle.FindFirst( 
                TreeScope.Children, idMenuCondition );

            // start submenu

            PropertyCondition idSubMenuCondition 
              = new PropertyCondition( 
                AutomationElement.AutomationIdProperty, 
                "mFirstLevelMenuList" );

            // list

            AutomationElement subMenuWnd 
              = menuWnd.FindFirst( TreeScope.Children, 
                idSubMenuCondition );

            // list item

            PropertyCondition typeItemCondition 
              = new PropertyCondition( 
                AutomationElement.ControlTypeProperty, 
                ControlType.ListItem );

            PropertyCondition nameItemCondition 
              = new PropertyCondition( 
                AutomationElement.NameProperty, 
                "Autodesk.Windows.ApplicationMenuItem" );

            PropertyCondition idItemCondition 
              = new PropertyCondition( 
                AutomationElement.AutomationIdProperty, 
                "ID_REVIT_FILE_OPEN" );

            AndCondition andItemCondition 
              = new AndCondition( idItemCondition, 
                typeItemCondition );

            AutomationElement openItemWnd 
              = subMenuWnd.FindFirst( TreeScope.Children, 
                andItemCondition );

            PropertyCondition typeButtonCondition 
              = new PropertyCondition( 
                AutomationElement.ControlTypeProperty, 
                ControlType.Button );

            AutomationElementCollection openButtons 
              = openItemWnd.FindAll( TreeScope.Children, 
                typeButtonCondition );

            foreach( AutomationElement openButton 
              in openButtons )
            {
              PropertyCondition typeImageCondition 
                = new PropertyCondition( 
                  AutomationElement.ControlTypeProperty, 
                  ControlType.Image );

              AutomationElementCollection images 
                = openButton.FindAll( TreeScope.Children, 
                  typeImageCondition );

              // search a button with an image

              if( images.Count > 0 )
              {
                InvokePattern invPattern 
                  = openButton.GetCurrentPattern( 
                    InvokePattern.Pattern ) as InvokePattern;

                invPattern.Invoke();
              }
            }

            // open dialog window

            // pause while dialog is being opened

            Thread.Sleep( 700 );

            // re-read revit window components to find new dialog

            PropertyCondition nameOpenDlgCondition 
              = new PropertyCondition( 
                AutomationElement.NameProperty, 
                "Öffnen" ); // us-EN "Open"

            AutomationElementCollection allOpenDlgs 
              = mainWndFromHandle.FindAll( 
                TreeScope.Children, nameOpenDlgCondition );

            foreach( AutomationElement openOpenDlgWnd 
              in allOpenDlgs )
            {
              if( openOpenDlgWnd.Current.LocalizedControlType 
                == "Dialogfeld" )
              {
                // comboBox has also an&

                PropertyCondition typeComboBoxCondition 
                  = new PropertyCondition( 
                    AutomationElement.ControlTypeProperty, 
                    ControlType.ComboBox );

                PropertyCondition idComboBoxCondition 
                  = new PropertyCondition( 
                    AutomationElement.AutomationIdProperty, 
                    "13006" );

                AndCondition andComboBoxCondition 
                  = new AndCondition( idComboBoxCondition, 
                    typeComboBoxCondition );

                AutomationElement comboBoxWnd 
                  = openOpenDlgWnd.FindFirst( TreeScope.Children, 
                    andComboBoxCondition );

                // &edit field

                PropertyCondition typeEditCondition 
                  = new PropertyCondition( 
                    AutomationElement.ControlTypeProperty, 
                    ControlType.Edit );

                PropertyCondition idEditCondition 
                  = new PropertyCondition( 
                    AutomationElement.AutomationIdProperty, 
                    "1001" );

                AndCondition andEditCondition 
                  = new AndCondition( idEditCondition, 
                    typeEditCondition );

                AutomationElement editWnd 
                  = comboBoxWnd.FindFirst( TreeScope.Children, 
                    andEditCondition );

                Thread.Sleep( 900 );

                ValuePattern valPattern 
                  = editWnd.GetCurrentPattern( 
                    ValuePattern.Pattern ) as ValuePattern;

                // paste file path into the edit field

                valPattern.SetValue( filePath );

                // press ok button
                
                PropertyCondition idOpenButtonCondition 
                  = new PropertyCondition( 
                    AutomationElement.AutomationIdProperty, 
                    "1" );

                AndCondition andOpenButtonCondition 
                  = new AndCondition( idOpenButtonCondition, 
                    typeButtonCondition );

                AutomationElement openButton 
                  = openOpenDlgWnd.FindFirst( TreeScope.Children, 
                    andOpenButtonCondition );

                InvokePattern invPattern 
                  = openButton.GetCurrentPattern( 
                    InvokePattern.Pattern ) as InvokePattern;

                if( invPattern != null )
                {
                  invPattern.Invoke();
                }
              }
            }
          }
        }
      }

      void f()
      {
        AutomationElement mainWndFromHandle 
          = AutomationElement.FromHandle( 
            _hWndRevit.Handle ); // the revit window handle

        PropertyCondition nameRibbonCondition 
          = new PropertyCondition( 
            AutomationElement.NameProperty, 
            "RibbonHostWindow" );

        PropertyCondition typeRibbonCondition 
          = new PropertyCondition( 
            AutomationElement.ControlTypeProperty, 
            ControlType.Pane );

        AndCondition andCondition 
          = new AndCondition( 
            typeRibbonCondition, 
            nameRibbonCondition );

        ribbonWnd = mainWndFromHandle.FindFirst( 
          TreeScope.Children, andCondition );

        PropertyCondition aIDCondition 
          = new PropertyCondition( 
            AutomationElement.AutomationIdProperty, 
            "ADD_INS_TAB" );

        AutomationElement addinbutton 
          = ribbonWnd.FindFirst( 
          TreeScope.Children, aIDCondition );

        // show addin panel by pressing the tab header

        InvokePattern invPattern 
          = addinbutton.GetCurrentPattern( 
            InvokePattern.Pattern ) as InvokePattern;

        invPattern.Invoke();

        // pause, so ribbon panels can re-arrange
        
        System.Threading.Thread.Sleep( 1000 );

        PropertyCondition aIDPanelCondition 
          = new PropertyCondition( 
            AutomationElement.AutomationIdProperty, 
            "ADD_INS_TAB_PanelBarScrollViewer" );

        AutomationElement addinPanel 
          = ribbonWnd.FindFirst( TreeScope.Children, 
            aIDPanelCondition );

        PropertyCondition aIDTestPanelCondition 
          = new PropertyCondition( 
            AutomationElement.AutomationIdProperty, 
            "CustomCtrl_%ADD_INS_TAB%TestPanel" );

        AutomationElement testPanel 
          = addinPanel.FindFirst( TreeScope.Children, 
            aIDTestPanelCondition );

        PropertyCondition aIDContainerCondition 
          = new PropertyCondition( 
            AutomationElement.AutomationIdProperty, 
            "CustomCtrl_%CustomCtrl_%ADD_INS_TAB%TestPanel%TestButton_RibbonItemControl" );

        AutomationElement testContainer 
          = testPanel.FindFirst( TreeScope.Children, 
            aIDContainerCondition );

        PropertyCondition aIDTestButtonCondition 
          = new PropertyCondition( 
            AutomationElement.AutomationIdProperty, 
            "CustomCtrl_%CustomCtrl_%ADD_INS_TAB%TestPanel%TestButton" );

        AutomationElement testButton 
          = testContainer.FindFirst( TreeScope.Children, 
            aIDTestButtonCondition );

        InvokePattern invPatternButton 
          = testButton.GetCurrentPattern( 
            InvokePattern.Pattern ) as InvokePattern;

        // now press our button via uiautomation

        invPatternButton.Invoke();
      }
#endif
      #endregion // Blog post sample code

      [DllImport( "user32.dll", SetLastError = true )]
      static extern IntPtr FindWindowEx( 
        IntPtr hwndParent, 
        IntPtr hwndChildAfter, 
        string lpszClass, 
        string lpszWindow );

      [DllImport( "user32.dll" )]
      static extern IntPtr SendMessage( 
        IntPtr hWnd, 
        uint Msg, 
        IntPtr wParam, 
        IntPtr lParam );

      [DllImport( "user32.dll" )]
      [return: MarshalAs( UnmanagedType.Bool )]
      static extern bool SetForegroundWindow( 
        IntPtr hWnd );

      private const uint WM_LBUTTONDOWN = 0x0201;
      private const uint WM_LBUTTONUP = 0x0202;

      private AutomationElement m_mainWndFromHandle = null;
      private AutomationElement m_ribbonWnd = null;
      private List<Tab> tabs = new List<Tab>();

      public Form1()
      {
        InitializeComponent();

        textBox1.Text = Path.Combine( 
          Path.GetDirectoryName( 
            Assembly.GetExecutingAssembly().Location ), 
          "Test.rvt" );
      }

      private bool GetRevitWindows()
      {
        Process[] processes 
          = Process.GetProcessesByName( "Revit" );

        WindowHandle _hWndRevit = null;

        if( 0 < processes.Length )
        {
          IntPtr h = processes[0].MainWindowHandle;

          _hWndRevit = new WindowHandle( h );
        }
        
        if( _hWndRevit != null )
        {
          m_mainWndFromHandle = AutomationElement
            .FromHandle( _hWndRevit.Handle );

          PropertyCondition nameRibbonCondition 
            = new PropertyCondition( 
              AutomationElement.NameProperty, 
              "RibbonHostWindow" );

          PropertyCondition typeRibbonCondition 
            = new PropertyCondition( 
              AutomationElement.ControlTypeProperty, 
              ControlType.Pane );

          AndCondition andCondition 
            = new AndCondition( typeRibbonCondition, 
              nameRibbonCondition );


          m_ribbonWnd = m_mainWndFromHandle.FindFirst( 
            TreeScope.Children, andCondition );

          if( m_ribbonWnd != null )
          {
            return true;
          }
        }
        return false;
      }

      private void FillTabs()
      {
        tabs.Clear();
        PropertyCondition typeButtonCondition 
          = new PropertyCondition( 
            AutomationElement.ControlTypeProperty, 
            ControlType.Button );


        AutomationElementCollection allButtons 
          = m_ribbonWnd.FindAll( TreeScope.Children, 
            typeButtonCondition );

        foreach( AutomationElement button 
          in allButtons )
        {
          // only select real, visible tabs, 
          // omit minimize / maximize buttons etc.

          if( button.Current.AutomationId.ToUpper().EndsWith( "TAB" ) 
            || button.Current.AutomationId.Equals( "Modify" ) )
          {
            tabs.Add( new Tab( 
              button.Current.AutomationId, 
              button.Current.AutomationId, button ) );
          }
        }
      }

      private void FillTreeView()
      {
        treeView1.BeginUpdate();
        treeView1.Nodes.Clear();

        foreach( Tab tab in tabs )
        {
          TreeNode treeNode = new TreeNode( tab.title );
          treeNode.Name = tab.automationID;
          treeNode.Tag = tab.automationElement;

          treeView1.Nodes.Add( treeNode );
        }
        treeView1.EndUpdate();
        treeView1.ExpandAll();
      }

      private void PushTab( AutomationElement autoElem )
      {
        try
        {
          autoElem.SetFocus();
          
          InvokePattern invPattern 
            = autoElem.GetCurrentPattern( 
              InvokePattern.Pattern ) as InvokePattern;

          invPattern.Invoke();
        }
        catch
        {
          try
          {
            autoElem.SetFocus();
            TogglePattern togglePattern 
              = autoElem.GetCurrentPattern( 
                TogglePattern.Pattern ) as TogglePattern;

            if( togglePattern.Current.ToggleState 
              == ToggleState.On )
            {
              // do something useful...
            }
            else
            {
              togglePattern.Toggle();
            }
          }
          catch
          {
          }
        }
      }

      private static void CloseFileViaUIAutomation( 
        bool saveBeforeClosing )
      {
        IntPtr startButtonHandle = FindWindowEx( 
          IntPtr.Zero, IntPtr.Zero, 
          "AdApplicationButton", 
          "AdApplicationButton" );

        if( startButtonHandle != IntPtr.Zero )
        {
          SendMessage( startButtonHandle, 
            WM_LBUTTONDOWN, IntPtr.Zero, IntPtr.Zero );

          SendMessage( startButtonHandle, 
            WM_LBUTTONUP, IntPtr.Zero, IntPtr.Zero );

          // wait until menu appears

          System.Threading.Thread.Sleep( 200 ); 

          Process[] processes 
            = Process.GetProcessesByName( "Revit" );

          WindowHandle _hWndRevit = null;

          if( 0 < processes.Length )
          {
            IntPtr h = processes[0].MainWindowHandle;

            _hWndRevit = new WindowHandle( h );
          }

          if( _hWndRevit != null )
          {
            // revit window
            AutomationElement mainWndFromHandle 
              = AutomationElement.FromHandle( 
                _hWndRevit.Handle );

            // start menu

            PropertyCondition idMenuCondition 
              = new PropertyCondition( 
                AutomationElement.AutomationIdProperty, 
                "Id_ApplicationMenuWindow" );

            AutomationElement menuWnd 
              = mainWndFromHandle.FindFirst( 
                TreeScope.Children, idMenuCondition );

            // start submenu

            PropertyCondition idSubMenuCondition 
              = new PropertyCondition( 
                AutomationElement.AutomationIdProperty, 
                "mFirstLevelMenuList" );

            // list

            AutomationElement subMenuWnd 
              = menuWnd.FindFirst( 
                TreeScope.Children, 
                idSubMenuCondition );


            PropertyCondition typeItemCondition 
              = new PropertyCondition( 
                AutomationElement.ControlTypeProperty, 
                ControlType.ListItem );

            PropertyCondition idItemCondition 
              = new PropertyCondition( 
                AutomationElement.AutomationIdProperty, 
                "ID_REVIT_FILE_CLOSE" );

            AndCondition andItemCondition 
              = new AndCondition( idItemCondition, 
                typeItemCondition );

            AutomationElement openItemWnd 
              = subMenuWnd.FindFirst( 
              TreeScope.Children, andItemCondition );

            PropertyCondition idButtonCondition 
              = new PropertyCondition( 
                AutomationElement.AutomationIdProperty, 
                "ID_REVIT_FILE_CLOSE_RibbonItemControl" );

            AutomationElement button 
              = openItemWnd.FindFirst( 
              TreeScope.Children, idButtonCondition );

            PropertyCondition idSubButtonCondition 
              = new PropertyCondition( 
                AutomationElement.AutomationIdProperty, 
                "ID_REVIT_FILE_CLOSE_MenuCommandButton" );

            AutomationElement subButton 
              = button.FindFirst( 
              TreeScope.Children, 
              idSubButtonCondition );


            InvokePattern invPattern 
              = subButton.GetCurrentPattern( 
              InvokePattern.Pattern ) as InvokePattern;

            invPattern.Invoke();

            // wait for dialog

            System.Threading.Thread.Sleep( 600 );

            int max = 5;

            for( int i = 0; i < max; i++ )
            {
              System.Threading.Thread.Sleep( 200 );

              CloseSaveRequestDlg( saveBeforeClosing, mainWndFromHandle );
            }
          }
        }
      }

      public static void CloseSaveRequestDlg( 
        bool saveBeforeClosing, 
        AutomationElement mainWndFromHandle )
      {
        PropertyCondition dlgCondition 
          = new PropertyCondition( 
            AutomationElement.NameProperty, 
            "Datei speichern" );

        AutomationElement dlgWnd 
          = mainWndFromHandle.FindFirst( 
            TreeScope.Children, dlgCondition );

        if( dlgWnd != null )
        {
          PropertyCondition nameCondition 
            = new PropertyCondition( 
              AutomationElement.NameProperty, 
              "Nein" );

          if( saveBeforeClosing )
          {
            nameCondition = new PropertyCondition( 
              AutomationElement.NameProperty, "Ja" );
          }
          AutomationElement button = dlgWnd.FindFirst( 
            TreeScope.Children, nameCondition );

          InvokePattern invPattern 
            = button.GetCurrentPattern( 
              InvokePattern.Pattern ) as InvokePattern;

          invPattern.Invoke();
        }
      }

      private void OpenFileViaUIAutomation( 
        string filePath )
      {
        IntPtr startButtonHandle = FindWindowEx( 
          IntPtr.Zero, IntPtr.Zero, 
          "AdApplicationButton", 
          "AdApplicationButton" );

        if( startButtonHandle != IntPtr.Zero )
        {
          SendMessage( startButtonHandle, 
            WM_LBUTTONDOWN, IntPtr.Zero, IntPtr.Zero );

          SendMessage( startButtonHandle, 
            WM_LBUTTONUP, IntPtr.Zero, IntPtr.Zero );

          Process[] processes 
            = Process.GetProcessesByName( "Revit" );

          WindowHandle _hWndRevit = null;
          if( 0 < processes.Length )
          {
            IntPtr h = processes[0].MainWindowHandle;

            _hWndRevit = new WindowHandle( h );
          }
          if( _hWndRevit != null )
          {
            // revit window
            AutomationElement mainWndFromHandle 
              = AutomationElement.FromHandle( 
              _hWndRevit.Handle );

            // start menu

            PropertyCondition idMenuCondition 
              = new PropertyCondition( 
                AutomationElement.AutomationIdProperty, 
                "Id_ApplicationMenuWindow" );

            AutomationElement menuWnd 
              = mainWndFromHandle.FindFirst( 
                TreeScope.Children, idMenuCondition );

            // start submenu

            PropertyCondition idSubMenuCondition 
              = new PropertyCondition( 
                AutomationElement.AutomationIdProperty,
                "mFirstLevelMenuList" );

            // list

            AutomationElement subMenuWnd 
              = menuWnd.FindFirst( 
                TreeScope.Children, 
                idSubMenuCondition );

            // listItem

            PropertyCondition typeItemCondition = new PropertyCondition( AutomationElement.ControlTypeProperty, ControlType.ListItem );
            PropertyCondition nameItemCondition = new PropertyCondition( AutomationElement.NameProperty, "Autodesk.Windows.ApplicationMenuItem" );
            PropertyCondition idItemCondition = new PropertyCondition( AutomationElement.AutomationIdProperty, "ID_REVIT_FILE_OPEN" );

            AndCondition andItemCondition = new AndCondition( idItemCondition, typeItemCondition );

            AutomationElement openItemWnd = subMenuWnd.FindFirst( TreeScope.Children, andItemCondition );

            PropertyCondition typeButtonCondition = new PropertyCondition( AutomationElement.ControlTypeProperty, ControlType.Button );
            PropertyCondition idOpenFileCondition = new PropertyCondition( AutomationElement.AutomationIdProperty, "ID_REVIT_FILE_OPEN_RibbonItemControl" );

            PropertyCondition idOpenFileCondition2 = new PropertyCondition( AutomationElement.AutomationIdProperty, "ID_REVIT_FILE_OPEN_MenuCommandButton" );


            AutomationElement openFileWnd = openItemWnd.FindFirst( TreeScope.Children, idOpenFileCondition );
            AutomationElement openFileSubWnd = openFileWnd.FindFirst( TreeScope.Children, idOpenFileCondition2 );


            InvokePattern invPatternOpenFile = openFileSubWnd.GetCurrentPattern( InvokePattern.Pattern ) as InvokePattern;
            invPatternOpenFile.Invoke();

            // open dialog window
            PropertyCondition typeOpenDlgCondition = new PropertyCondition( AutomationElement.ControlTypeProperty, ControlType.Window );
            PropertyCondition nameOpenDlgCondition = new PropertyCondition( AutomationElement.NameProperty, "Öffnen" ); // en-US: "Open"

            AndCondition andOpenDlgCondition = new AndCondition( nameOpenDlgCondition, typeOpenDlgCondition );

            Thread.Sleep( 600 );

            AutomationElementCollection allOpenDlgs = mainWndFromHandle.FindAll( TreeScope.Children, nameOpenDlgCondition );
            //typeOpenDlgCondition andOpenDlgCondition
            foreach( AutomationElement openOpenDlgWnd in allOpenDlgs )
            {
              if( openOpenDlgWnd.Current.LocalizedControlType == "Dialogfeld" ) // en-US: ?
              {
                // comboBox

                PropertyCondition typeComboBoxCondition = new PropertyCondition( AutomationElement.ControlTypeProperty, ControlType.ComboBox );
                PropertyCondition idComboBoxCondition = new PropertyCondition( AutomationElement.AutomationIdProperty, "13006" );

                AndCondition andComboBoxCondition = new AndCondition( idComboBoxCondition, typeComboBoxCondition );

                AutomationElement comboBoxWnd = openOpenDlgWnd.FindFirst( TreeScope.Children, andComboBoxCondition );

                // edit

                PropertyCondition typeEditCondition = new PropertyCondition( AutomationElement.ControlTypeProperty, ControlType.Edit );
                PropertyCondition idEditCondition = new PropertyCondition( AutomationElement.AutomationIdProperty, "1001" );

                AndCondition andEditCondition = new AndCondition( idEditCondition, typeEditCondition );

                AutomationElement editWnd = comboBoxWnd.FindFirst( TreeScope.Children, andEditCondition );
                Thread.Sleep( 900 ); // give it some time
                ValuePattern valPattern = editWnd.GetCurrentPattern( ValuePattern.Pattern ) as ValuePattern;
                // try it until the value has been pasted successfully

                while( valPattern.Current.Value == "" )
                {
                  Thread.Sleep( 300 );
                  valPattern.SetValue( filePath );
                }

                // press ok button
                PropertyCondition idOpenButtonCondition = new PropertyCondition( AutomationElement.AutomationIdProperty, "1" );
                AndCondition andOpenButtonCondition = new AndCondition( idOpenButtonCondition, typeButtonCondition );
                AutomationElement openButton = openOpenDlgWnd.FindFirst( TreeScope.Children, andOpenButtonCondition );
                openButton.SetFocus();
                InvokePattern invPattern = openButton.GetCurrentPattern( InvokePattern.Pattern ) as InvokePattern;
                if( invPattern != null )
                {
                  invPattern.Invoke();
                }

              }
            }
          }
        }
      }

      private void button_ok_Click( object sender, EventArgs e )
      {
        Close();
      }

      private void button_readTabs_Click( object sender, EventArgs e )
      {
        if( GetRevitWindows() )
        {
          FillTabs();
          FillTreeView();
        }
      }

      private void treeView1_AfterSelect( object sender, TreeViewEventArgs e )
      {
        PushTab( e.Node.Tag as AutomationElement );
        SetForegroundWindow( this.Handle );
      }

      private void button_closeFile_Click( object sender, EventArgs e )
      {
        CloseFileViaUIAutomation( true );
      }

      private void button_closeFileSaveNot_Click( object sender, EventArgs e )
      {
        CloseFileViaUIAutomation( false );
      }

      private void button_openFile_Click( object sender, EventArgs e )
      {
        if( File.Exists( textBox1.Text ) )
        {
          OpenFileViaUIAutomation( textBox1.Text );
        }
      }
    }

    // just a container object

    public class Tab
    {
      public string title = "";
      public string automationID = "";
      public AutomationElement automationElement = null;

      public Tab( string title, string automationID )
      {
        this.title = title;
        this.automationID = automationID;
      }
      public Tab( string title, string automationID, AutomationElement automationElement )
      {
        this.title = title;
        this.automationID = automationID;
        this.automationElement = automationElement;
      }
    }

    // this is some code from The Building Coder:

    public class WindowHandle : System.Windows.Forms.IWin32Window
    {
      IntPtr _hwnd;

      public WindowHandle( IntPtr h )
      {
        _hwnd = h;
      }

      public IntPtr Handle
      {
        get
        {
          return _hwnd;
        }
      }
    }
  }
