#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;
#endregion

namespace DuplicatedSymbolLosesMaterial
{
  [Transaction( TransactionMode.Manual )]
  public class Command : IExternalCommand
  {
    public Result Execute(
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      UIApplication uiapp = commandData.Application;
      UIDocument uidoc = uiapp.ActiveUIDocument;
      Application app = uiapp.Application;
      Document doc = uidoc.Document;
      Selection sel = uidoc.Selection;
      FamilyInstance inst = null;

      if( 1 == sel.Elements.Size )
      {
        foreach( Element e in sel.Elements )
        {
          inst = e as FamilyInstance;

          break;
        }
      }

      if( null == inst )
      {
        message = "Please select one "
          + "single structural column";

        return Result.Failed;
      }

      using( Transaction tx 
        = new Transaction( doc ) )
      {
        tx.Start( "Duplicate Symbol" );

        FamilySymbol symbol = inst.Symbol;

        string name = symbol.Name 
          + DateTime.Now.Ticks.ToString();

        int nMaterialsBefore 
          = symbol.Materials.Size;

        symbol = inst.Symbol.Duplicate( name ) 
          as FamilySymbol;

        // The model is in a temporary state that does 
        // not make sense. Regenerate to clean this up.

        int nMaterialsAfter 
          = symbol.Materials.Size;

        doc.Regenerate();

        nMaterialsAfter = symbol.Materials.Size;

        Debug.Assert( 
          nMaterialsAfter.Equals( nMaterialsBefore ),
          "why does the material get lost, please?" );

        tx.Commit();
      }
      return Result.Succeeded;
    }
  }
}
