﻿using System;
using Autodesk.Revit.DB.ExtensibleStorage;

namespace Common
{
  public static class SchemaHelper
  {
    public static Schema GetFamilySchema()
    {
      var schema = Schema.Lookup( GetSchemaId() );
      if( schema != null )
        return schema;
      return CreateSchema();
    }

    private static Schema CreateSchema()
    {
      var buider = new SchemaBuilder( GetSchemaId() );
      buider.SetSchemaName( "FamilyTestSchema" );
      buider.AddSimpleField( "Id", typeof( Guid ) );
      return buider.Finish();
    }

    private static Guid GetSchemaId()
    {
      return new Guid( 
        "1F88140C-B84A-4C6B-A998-722D1173200F" );
    }
  }
}