﻿using System;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.ExtensibleStorage;
using Autodesk.Revit.UI;
using Common;

namespace ExtStoragesFirstStep
{
  [Transaction( TransactionMode.Manual )]
  public class SetSchemaToFamilyCommand : IExternalCommand
  {
    public Result Execute( ExternalCommandData commandData, ref string message, ElementSet elements )
    {
      var uiapp = commandData.Application;
      var uidoc = uiapp.ActiveUIDocument;
      var doc = uidoc.Document;

      if( doc.IsFamilyDocument )
        SetEntityToOwnerFamily( doc );
      else
        SetEntityToDocumentFamilies( doc );

      return Result.Succeeded;
    }

    private static void SetEntityToOwnerFamily( Document doc )
    {
      using( var tx = new Transaction( doc ) )
      {
        tx.Start( "Set ext storage entity for family" );
        SetEntityToFamily( doc.OwnerFamily );
        tx.Commit();
      }
    }

    private static void SetEntityToDocumentFamilies( Document doc )
    {
      var collector = new FilteredElementCollector( doc );
      var families = collector.OfClass( typeof( Family ) ).ToElements();
      using( var tx = new Transaction( doc ) )
      {
        tx.Start( "Set ext storage entity for document families" );
        foreach( var family in families )
          SetEntityToFamily( family );
        tx.Commit();
      }
    }

    private static void SetEntityToFamily( Element family )
    {
      var schema = SchemaHelper.GetFamilySchema();
      var entity = new Entity( schema );
      entity.Set( "Id", Guid.NewGuid() );
      family.SetEntity( entity );
    }
  }
}