//#define USE_SUB_TRANSACTION
//#define USE_TRANSACTION
//#define USE_REFRESH
#define USE_REFRESH_AND_SCOPE

#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Threading;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
#endregion

namespace FachadaCinetica
{
  [Transaction( TransactionMode.Manual )]
  public class Command : IExternalCommand
  {
    /// <summary>
    /// Verifica se nmero  par ou impar
    /// </summary>
    bool Par_Impar( int num )
    {
      return num % 2 == 0;
    }

    public Result Calcula_Padrao(
      Document doc,
      ICollection<ElementId> Paneis,
      double i )
    {
      foreach( ElementId el in Paneis )
      {
        int panelNum = el.IntegerValue;

        //FamilyInstance panel = doc.get_Element( el ) // 2012
        //  as FamilyInstance;

        FamilyInstance panel = doc.GetElement( el ) // 2013
          as FamilyInstance;

        Parameter junta = panel.get_Parameter(
          "Junta" );

        junta.Set(
          Par_Impar( panelNum ) ? i : i - 0.05 );
      }
      return Result.Succeeded;
    }

    /// <summary>
    /// Attempt to refresh view using SubTransactions
    /// </summary>
    void KineticFacadeUsingSubTransactions(
      Document doc,
      ICollection<ElementId> Paneis )
    {
      Transaction tran = new Transaction( doc );

      SubTransaction sTra1 = new SubTransaction( doc );
      SubTransaction sTra2 = new SubTransaction( doc );
      SubTransaction sTra3 = new SubTransaction( doc );
      SubTransaction sTra4 = new SubTransaction( doc );

      tran.Start( "Muda a fachada" );

      Debug.Print( "SubTransaction 1 start" );
      sTra1.Start();
      Calcula_Padrao( doc, Paneis, 0.10 );
      sTra1.Commit();
      doc.Regenerate();
      Debug.Print( "SubTransaction 1 commit" );

      Thread.Sleep( 2000 );

      Debug.Print( "SubTransaction 2 start" );
      sTra2.Start();
      Calcula_Padrao( doc, Paneis, 0.4 );
      sTra2.Commit();
      doc.Regenerate();
      Debug.Print( "SubTransaction 2 commit" );

      Thread.Sleep( 2000 );

      Debug.Print( "SubTransaction 3 start" );
      sTra3.Start();
      Calcula_Padrao( doc, Paneis, 0.05 );
      sTra3.Commit();
      doc.Regenerate();
      Debug.Print( "SubTransaction 3 commit" );

      Thread.Sleep( 2000 );

      Debug.Print( "SubTransaction 4 start" );
      sTra4.Start();
      Calcula_Padrao( doc, Paneis, 0.4 );
      sTra4.Commit();
      doc.Regenerate();
      Debug.Print( "SubTransaction 4 commit" );

      tran.Commit();
    }

    /// <summary>
    /// Attempt to refresh view using Transactions
    /// </summary>
    void KineticFacadeUsingTransactions(
      Document doc,
      ICollection<ElementId> Paneis )
    {
      string filepath = "C:/tmp/";
      string step_name = "Muda a fachada 1";

      Transaction tran = new Transaction( doc );

      Debug.Print( step_name + " start" );
      tran.Start( step_name );
      Calcula_Padrao( doc, Paneis, 0.10 );
      tran.Commit();
      Debug.Print( step_name + " commit" );
      doc.SaveAs( filepath + step_name + ".rvt" );

      Thread.Sleep( 2000 );

      step_name = step_name.Replace( '1', '2' );
      Debug.Print( step_name + " start" );
      tran.Start( step_name );
      Calcula_Padrao( doc, Paneis, 0.4 );
      tran.Commit();
      Debug.Print( step_name + " commit" );
      doc.SaveAs( filepath + step_name + ".rvt" );

      Thread.Sleep( 2000 );

      step_name = step_name.Replace( '2', '3' );
      Debug.Print( step_name + " start" );
      tran.Start( step_name );
      Calcula_Padrao( doc, Paneis, 0.05 );
      tran.Commit();
      Debug.Print( step_name + " commit" );
      doc.SaveAs( filepath + step_name + ".rvt" );

      Thread.Sleep( 2000 );

      step_name = step_name.Replace( '3', '4' );
      Debug.Print( step_name + " start" );
      tran.Start( step_name );
      Calcula_Padrao( doc, Paneis, 0.4 );
      tran.Commit();
      Debug.Print( step_name + " commit" );
    }

    /// <summary>
    /// Refresh view using RefreshActiveView
    /// </summary>
    void KineticFacadeUsingRefresh(
      UIDocument uidoc,
      ICollection<ElementId> Paneis )
    {
      Document doc = uidoc.Document;
      TransactionGroup group = new TransactionGroup( doc );
      Transaction tran = new Transaction( doc );

      group.Start( "Muda a fachada" );

      tran.Start( "Step 1 " );
      Calcula_Padrao( doc, Paneis, 0.10 );
      tran.Commit();

      uidoc.RefreshActiveView();

      Thread.Sleep( 2000 );

      tran.Start( "Step 2 " );
      Calcula_Padrao( doc, Paneis, 0.4 );
      tran.Commit();

      uidoc.RefreshActiveView();

      Thread.Sleep( 2000 );

      tran.Start( "Step 3 " );
      Calcula_Padrao( doc, Paneis, 0.05 );
      tran.Commit();

      uidoc.RefreshActiveView();

      Thread.Sleep( 2000 );

      tran.Start( "Step 4 " );
      Calcula_Padrao( doc, Paneis, 0.4 );
      tran.Commit();

      uidoc.RefreshActiveView();

      group.Assimilate();
    }

    /// <summary>
    /// Refresh view using RefreshActiveView 
    /// and proper transaction scoping.
    /// </summary>
    void KineticFacadeUsingRefreshAndScope(
      UIDocument uidoc,
      ICollection<ElementId> Paneis )
    {
      Document doc = uidoc.Document;

      using( TransactionGroup group 
        = new TransactionGroup( doc ) )
      {
        group.Start( "Muda a fachada" );

        using( Transaction tran 
          = new Transaction( doc ) )
        {
          tran.Start( "Step 1 " );
          Calcula_Padrao( doc, Paneis, 0.10 );
          tran.Commit();

          uidoc.RefreshActiveView();

          Thread.Sleep( 2000 );

          tran.Start( "Step 2 " );
          Calcula_Padrao( doc, Paneis, 0.4 );
          tran.Commit();

          uidoc.RefreshActiveView();

          Thread.Sleep( 2000 );

          tran.Start( "Step 3 " );
          Calcula_Padrao( doc, Paneis, 0.05 );
          tran.Commit();

          uidoc.RefreshActiveView();

          Thread.Sleep( 2000 );

          tran.Start( "Step 4 " );
          Calcula_Padrao( doc, Paneis, 0.4 );
          tran.Commit();

          uidoc.RefreshActiveView();
        }
        group.Assimilate();
      }
    }

    public Result Execute(
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      WaitCursor waitCursor = new WaitCursor();
      UIApplication uiapp = commandData.Application;
      UIDocument uidoc = uiapp.ActiveUIDocument;
      Application app = uiapp.Application;
      Document doc = uidoc.Document;

      FilteredElementCollector colecao
        = new FilteredElementCollector( doc )
          .WhereElementIsNotElementType()
          .OfCategory(
            BuiltInCategory.OST_CurtainWallPanels );

      ICollection<ElementId> Paneis
        = colecao.ToElementIds();

#if USE_SUB_TRANSACTION
      KineticFacadeUsingSubTransactions( doc, Paneis );
#endif // USE_SUB_TRANSACTION

#if USE_TRANSACTION
      KineticFacadeUsingTransactions( doc, Paneis );
#endif // USE_TRANSACTION

#if USE_REFRESH
      KineticFacadeUsingRefresh( uidoc, Paneis );
#endif // USE_REFRESH

#if USE_REFRESH_AND_SCOPE
      KineticFacadeUsingRefreshAndScope( uidoc, Paneis );
#endif // USE_REFRESH_AND_SCOPE

      return Result.Succeeded;
    }
  }
}
