#region Namespaces
using System;
using System.Collections.Generic;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using System.Reflection;
#endregion

namespace FamilyApi
{
  class App : IExternalApplication
  {
    /// <summary>
    /// Add buttons for our three commands 
    /// to the ribbon panel.
    /// </summary>
    void PopulatePanel( RibbonPanel p )
    {
      string path = Assembly.GetExecutingAssembly()
        .Location;

      RibbonItemData i1 = new PushButtonData(
          "TableLoadPlace", "1 Table Load and Place",
          path, "FamilyApi.CmdTableLoadPlace" );

      i1.ToolTip = "Load the table family and "
        + "place table instances";

      RibbonItemData i2 = new PushButtonData(
        "TableModify", "2 Table New Type Modify",
        path, "FamilyApi.CmdTableNewTypeModify" );

      i2.ToolTip = "Create new table type and "
        + "modify selected instances";

      RibbonItemData i3 = new PushButtonData(
        "KitchenUpdate", "3 Kitchen Update",
        path, "FamilyApi.CmdKitchenUpdate" );

      i3.ToolTip = "Select and update all "
        + "kitchen cabinets";

      p.AddStackedItems( i1, i2, i3 );
    }

    public Result OnStartup( 
      UIControlledApplication a )
    {
      PopulatePanel( 
        a.CreateRibbonPanel( 
          Util.Caption ) );

      return Result.Succeeded;
    }

    public Result OnShutdown( 
      UIControlledApplication a )
    {
      return Result.Succeeded;
    }
  }
}
