﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using Element = Autodesk.Revit.DB.Element;

namespace FamilyApi
{
  public partial class DoorPanelTypeSelectorForm : System.Windows.Forms.Form
  {
    public DoorPanelTypeSelectorForm(
      string current_door_panel_type_name,
      IEnumerable<Element> door_panel_types )
    {
      InitializeComponent();
      label2.Text = current_door_panel_type_name;
      comboBox1.DataSource = door_panel_types;
      comboBox1.DisplayMember = "Name";
      comboBox1.SelectedIndex = 0;
    }

    public Element SelectedItem
    {
      get
      {
        return comboBox1.SelectedItem as Element;
      }
    }

    private void button1_Click( object sender, EventArgs e )
    {
      DialogResult = System.Windows.Forms.DialogResult.OK;
      Close();
    }
  }
}
