﻿#region Namespaces
using System;
using System.Collections.Generic;
using System.Linq;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
#endregion

namespace FilterRailings
{
  [Transaction( TransactionMode.ReadOnly )]
  public class Command : IExternalCommand
  {
    public Result Execute(
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      UIApplication uiapp = commandData.Application;
      UIDocument uidoc = uiapp.ActiveUIDocument;
      Application app = uiapp.Application;
      Document doc = uidoc.Document;

      string [] ids
        = new FilteredElementCollector( doc )
          .OfCategory( 
            BuiltInCategory.OST_StairsRailing )
          .WhereElementIsNotElementType()
          .Select<Element,string>( 
            e => e.Id.IntegerValue.ToString() )
          .ToArray<string>();

      int n = ids.Length;

      string s = (0 == n)
        ? "No railings selected."
        : (n.ToString()
          + " railing"
          + ( 1 == n ? "" : "s" )
          + " selected: "
          + string.Join( ", ", ids )
          + ".");

      TaskDialog.Show( "Railings", s );

      return Result.Succeeded;
    }
  }
}
