﻿#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using DreamSeat;
#endregion

namespace GetLoops
{
  [Transaction( TransactionMode.ReadOnly )]
  public class CmdRefresh : IExternalCommand
  {
    public Result Execute(
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      UIApplication uiapp = commandData.Application;
      UIDocument uidoc = uiapp.ActiveUIDocument;
      Application app = uiapp.Application;
      Document doc = uidoc.Document;

      if( null == doc )
      {
        Util.ErrorMsg( "Please run this command in a valid"
          + " Revit project document." );
        return Result.Failed;
      }

      // Ensure we are in the right document

      Element projectInfo
        = new FilteredElementCollector( doc )
          .OfClass( typeof( ProjectInfo ) )
          .FirstElement();

      string uid = projectInfo.UniqueId;

      return Result.Succeeded;
    }
  }
}
