﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace GetLoops
{
  /// <summary>
  /// A bounding box for a collection of 2D integer points.
  /// </summary>
  class JtBoundingBox2dInt
  {
    /// <summary>
    /// Array of four ints, first two for 
    /// minimum, last two for maximum values.
    /// </summary>
    int[] _a;

    /// <summary>
    /// Initialise to infinite values.
    /// </summary>
    public JtBoundingBox2dInt()
    {
      _a = new int[4];
      _a[0] = _a[1] = int.MaxValue;
      _a[2] = _a[3] = int.MinValue;
    }

    /// <summary>
    /// Return current lower left corner.
    /// </summary>
    public Point2dInt Min
    {
      get { return new Point2dInt( _a[0], _a[1] ); }
    }

    /// <summary>
    /// Return current upper right corner.
    /// </summary>
    public Point2dInt Max
    {
      get { return new Point2dInt( _a[2], _a[3] ); }
    }

    public Point2dInt MidPoint
    {
      get 
      { 
        return new Point2dInt( 
          (int)(0.5 * ( _a[0] + _a[2] )), 
          (int)(0.5 * ( _a[1] + _a[3] )) ); 
      }
    }

    //public XYZ Min { get; set; }
    //public XYZ Max { get; set; }

    //public XYZ Min
    //{
    //  get { return T1; }
    //}

    //public XYZ Max
    //{
    //  get { return T2; }
    //}

    /// <summary>
    /// Expand bounding box to contain 
    /// the given new point.
    /// </summary>
    public void ExpandToContain( Point2dInt p )
    {
      if( p.X < _a[0] ) { _a[0] = p.X; }
      if( p.Y < _a[1] ) { _a[1] = p.Y; }
      if( p.X > _a[2] ) { _a[2] = p.X; }
      if( p.Y > _a[3] ) { _a[3] = p.Y; }
    }

    public JtBoundingBox2dInt( JtLoops loops )
    {
      foreach( JtLoop loop in loops )
      {
        foreach( Point2dInt p in loop )
        {
          ExpandToContain( p );
        }
      }
    }
  }
}
