﻿using System;
using System.Collections.Generic;

namespace GetLoops
{
  class JtLoop : List<Point2dInt>
  {
    public JtLoop( int capacity )
      : base( capacity )
    {
    }

    public override string ToString()
    {
      return string.Join( ", ", this );
    }

    public new void Add( Point2dInt p )
    {
      if( 0 == Count 
        || !p.Equals( this[Count - 1] ) )
      {
        base.Add( p );
      }
    }
  }

  class JtLoops : List<JtLoop>
  {
    public JtLoops( int capacity )
      : base( capacity )
    {
    }

    public static JtLoops operator+( JtLoops a, JtLoops b )
    {
      int na = a.Count;
      int nb = b.Count;
      JtLoops sum = new JtLoops( na + nb );
      sum.AddRange( a );
      sum.AddRange( b );
      return sum;
    }
  }
}
