#region Namespaces
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;
using System;
using System.Data;
#endregion

namespace Grenov
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;
            Selection sel = uidoc.Selection;
            Reference reference = sel.PickObject(ObjectType.Element);
            Element elem = doc.GetElement(reference.ElementId);

            CurveLoop crvLoop = null;

            if (elem.Category.Name == "Windows")
            {
                FamilyInstance window = elem as FamilyInstance;
                Wall wall = window.Host as Wall;
                XYZ basisY = XYZ.BasisY;
                try
                {
                    crvLoop = Autodesk.Revit.DB.IFC.ExporterIFCUtils.GetInstanceCutoutFromWall(doc, wall, window, out basisY);
                    using (TaskDialog td = new TaskDialog("SuccessMessage"))
                    {
                        td.MainInstruction = "Got the curve loop.";
                        td.Show();
                    }
                }
                catch (Exception ex)
                {
                    using (TaskDialog td = new TaskDialog("ErrorMessage"))
                    {
                        td.MainInstruction = "Failed to get the curve loop.";
                        td.MainContent = ex.Message;
                        td.Show();
                    }
                }
                
            }

            if (crvLoop == null)
            {
                return Result.Failed ;
            }
            else
            {
                return Result.Succeeded;
            }

            
        }


    }

}