﻿using CefSharp;
using CefSharp.WinForms;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Runtime.InteropServices;
using System.Security;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace IPC_test_browser_process
{
    public partial class Form_Browser : Form
    {

        public static Queue<string> BrowserToRevitActions = new Queue<string>();
        public static Queue<string> RevitToBrowserActions = new Queue<string>();

        ChromiumWebBrowser browser = null;

        Timer action_timer = new Timer() { Interval = 300};

        public Form_Browser()
        {
            InitializeComponent();

            // send this window's hwnd back (finish the handshake)
            sendMessage("hwnd:" + this.Handle.ToString());

            action_timer.Tick += Action_timer_Tick;
            action_timer.Start();

        }

        private void Action_timer_Tick(object sender, EventArgs e)
        {
            
            if (BrowserToRevitActions.Count > 0)
            {
                this.Visible = false;
                string action = BrowserToRevitActions.Dequeue();
                sendMessage(action);
            }
            
            if (RevitToBrowserActions.Count > 0)
            {
                string action = RevitToBrowserActions.Dequeue();
                // call a javascript-method in the html-file
                browser.ExecuteScriptAsync("receiveFromRevit", new string[] { action });
            }

        }

        private void Form_Browser_Load(object sender, EventArgs e)
        {
            initializeBrowser();
        }

        #region code from https://code.msdn.microsoft.com/windowsapps/CSReceiveWMCOPYDATA-dbbc7ed7/sourcecode?fileId=21692&pathId=224762670

        private void sendMessage(string message)
        {

            // Prepare the COPYDATASTRUCT struct with the data to be sent. 
            MyStruct myStruct;

            myStruct.Message = message;

            // Marshal the managed struct to a native block of memory. 
            int myStructSize = Marshal.SizeOf(myStruct);
            IntPtr pMyStruct = Marshal.AllocHGlobal(myStructSize);
            try
            {
                Marshal.StructureToPtr(myStruct, pMyStruct, true);

                COPYDATASTRUCT cds = new COPYDATASTRUCT();
                cds.cbData = myStructSize;
                cds.lpData = pMyStruct;

                // Send the COPYDATASTRUCT struct through the WM_COPYDATA message to  
                // the receiving window. (The application must use SendMessage,  
                // instead of PostMessage to send WM_COPYDATA because the receiving  
                // application must accept while it is guaranteed to be valid.) 
                NativeMethod.SendMessage(Program.revit_hwnd, WM_COPYDATA, this.Handle, ref cds);

                int result = Marshal.GetLastWin32Error();
                if (result != 0)
                {
                    // sometimes there's a false alarm here... remove the msgbox
                    //MessageBox.Show(String.Format(
                    //    "SendMessage(WM_COPYDATA) (Browser->Revit) failed w/err 0x{0:X}", result));
                }
            }
            finally
            {
                Marshal.FreeHGlobal(pMyStruct);
            }

        }

        protected override void WndProc(ref Message m)
        {
            if (m.Msg == WM_COPYDATA)
            {
                // Get the COPYDATASTRUCT struct from lParam. 
                COPYDATASTRUCT cds = (COPYDATASTRUCT)m.GetLParam(typeof(COPYDATASTRUCT));

                // If the size matches 
                if (cds.cbData == Marshal.SizeOf(typeof(MyStruct)))
                {
                    // Marshal the data from the unmanaged memory block to a  
                    // MyStruct managed struct. 
                    MyStruct myStruct = (MyStruct)Marshal.PtrToStructure(cds.lpData,
                        typeof(MyStruct));

                    RevitToBrowserActions.Enqueue(myStruct.Message);

                    // show the window again
                    this.Visible = true;
                    this.Activate();
                    
                }
            }

            base.WndProc(ref m);
        }


        [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
        internal struct MyStruct
        {
            // Kim: use 4 MB message size. Using a dynamic size is probably possible, but would require some Googling 
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 4096)]
            public string Message;
        }

        /// <summary> 
        /// An application sends the WM_COPYDATA message to pass data to another  
        /// application 
        /// </summary> 
        internal const int WM_COPYDATA = 0x004A;

        /// <summary> 
        /// The COPYDATASTRUCT structure contains data to be passed to another  
        /// application by the WM_COPYDATA message.  
        /// </summary> 
        [StructLayout(LayoutKind.Sequential)]
        internal struct COPYDATASTRUCT
        {
            public IntPtr dwData;       // Specifies data to be passed 
            public int cbData;          // Specifies the data size in bytes 
            public IntPtr lpData;       // Pointer to data to be passed 
        }

        /// <summary> 
        /// The class exposes Windows APIs to be used in this code sample. 
        /// </summary> 
        [SuppressUnmanagedCodeSecurity]
        internal class NativeMethod
        {
            /// <summary> 
            /// Sends the specified message to a window or windows. The SendMessage  
            /// function calls the window procedure for the specified window and does  
            /// not return until the window procedure has processed the message.  
            /// </summary> 
            /// <param name="hWnd"> 
            /// Handle to the window whose window procedure will receive the message. 
            /// </param> 
            /// <param name="Msg">Specifies the message to be sent.</param> 
            /// <param name="wParam"> 
            /// Specifies additional message-specific information. 
            /// </param> 
            /// <param name="lParam"> 
            /// Specifies additional message-specific information. 
            /// </param> 
            /// <returns></returns> 
            [DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
            public static extern IntPtr SendMessage(IntPtr hWnd, int Msg,
                IntPtr wParam, ref COPYDATASTRUCT lParam);


            /// <summary> 
            /// The FindWindow function retrieves a handle to the top-level window  
            /// whose class name and window name match the specified strings. This  
            /// function does not search child windows. This function does not  
            /// perform a case-sensitive search. 
            /// </summary> 
            /// <param name="lpClassName">Class name</param> 
            /// <param name="lpWindowName">Window caption</param> 
            /// <returns></returns> 
            [DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
            public static extern IntPtr FindWindow(string lpClassName, string lpWindowName);
        }

        #endregion


        private bool initializeBrowser()
        {

            CefSettings settings = new CefSettings();
            settings.PackLoadingDisabled = false;
            settings.LogSeverity = LogSeverity.Disable;
            settings.BrowserSubprocessPath = AssemblyDirectory + "\\CefSharp.BrowserSubprocess.exe";

            settings.RemoteDebuggingPort = 1337;                                                   // For debugging CefSharp (http://localhost:1337 in browser)
            CefSharp.Cef.EnableHighDPISupport();

            CefSharpSettings.LegacyJavascriptBindingEnabled = true;
            CefSharpSettings.WcfTimeout = TimeSpan.Zero;

            if (!CefSharp.Cef.IsInitialized)
                if (!CefSharp.Cef.Initialize(settings))
                {
                    MessageBox.Show("Failed to initialize the document browser component");
                    return false;
                }

            browser = new ChromiumWebBrowser(AssemblyDirectory + "\\..\\index.html");
            browser.BrowserSettings.FileAccessFromFileUrls = CefState.Enabled;
            browser.BrowserSettings.UniversalAccessFromFileUrls = CefState.Enabled;

            ObjectForScripting _objectForScripting = new ObjectForScripting();
            browser.RegisterJsObject("dotNetInterface", _objectForScripting);

            browser.BrowserSettings.Javascript = CefState.Enabled;
            browser.BrowserSettings.JavascriptCloseWindows = CefState.Enabled;
            browser.BrowserSettings.WebGl = CefState.Enabled;
            browser.BrowserSettings.ApplicationCache = CefState.Disabled;

            // wrap the browser inside a WindowsFormsHost
            panelBrowser.Controls.Add(browser);
            return true;
        }

        /// <summary>
        /// Gets the path to the folder where this files compiled code lies 
        /// </summary>
        public static string AssemblyDirectory
        {
            get { return System.IO.Path.GetDirectoryName(new System.Uri(System.Reflection.Assembly.GetExecutingAssembly().CodeBase).LocalPath); }
        }

        private void Form_Browser_FormClosed(object sender, FormClosedEventArgs e)
        {
            // let the message handler know that the window closed
            sendMessage("close:");

            // shutdown cef 
            if (CefSharp.Cef.IsInitialized)
                Cef.Shutdown();

        }

    }
}
