﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Events;

namespace IPC_test_revit_plugin
{
    public class ApplicationClass : Autodesk.Revit.UI.IExternalApplication
    {

        // create an object taking care of the messaging (an invisible Forms.Form)
        public static MessageHandler messagehandler = new MessageHandler();

        public const int WM_SYSCOMMAND = 0x0112;
        public const int SC_CLOSE = 0xF060;

        [DllImport("user32.dll")]
        public static extern IntPtr SendMessage(IntPtr hWnd, uint Msg, int wParam, int lParam);

        public Result OnShutdown(UIControlledApplication application)
        {
            // make sure the browser process is closed
            if (MessageHandler.browser_pid != 0)
            {
                // this could be enough, but rather try to close the process 
                //SendMessage(MessageHandler.browser_hwnd, WM_SYSCOMMAND, SC_CLOSE, 0);

                Process[] processes = Process.GetProcesses();
                
                foreach (Process p in processes)
                {
                    if (p.Id == MessageHandler.browser_pid)
                    {
                        IntPtr hwnd = p.MainWindowHandle;
                        SendMessage(hwnd, WM_SYSCOMMAND, SC_CLOSE, 0);
                        break;
                    }
                }
            }

            return Result.Succeeded;
        }

        public Result OnStartup(UIControlledApplication application)
        {
            // assign the idling event, which enables runnning any Revit actions outside of the command
            application.Idling += application_Idling;
       
            RibbonPanel panel = application.CreateRibbonPanel("testing ext. process");

            // create the actual button
            PushButton LMpushButton = panel.AddItem(new PushButtonData("Open browser",
                    "Open browser", new System.Uri(System.Reflection.Assembly.GetExecutingAssembly().CodeBase).LocalPath, "IPC_test_revit_plugin.CommandClass")) as PushButton;

            LMpushButton.ToolTip = "Open browser as external process";
            //LMpushButton.LargeImage = nah, skip it
            string LMurl = "http://www.prodlib.com";

            // set the contextual help
            ContextualHelp LMcontextHelp = new ContextualHelp(ContextualHelpType.Url, LMurl);
            LMpushButton.SetContextualHelp(LMcontextHelp);
            
            return Result.Succeeded;

        }

        void application_Idling(object sender, IdlingEventArgs e)
        {
            // get the UIApplication object, which opens the Revit API for you...
            UIApplication uiApp = sender as UIApplication;
            
            if (MessageHandler.BrowserToRevitActions.Count > 0)
            {
                string action = MessageHandler.BrowserToRevitActions.Dequeue();

                // do your Revit tasks here
                MessageBox.Show("Text received from the browser window: " + action);

                // reply something back
                MessageHandler.RevitToBrowserActions.Enqueue("A message from the Revit plugin - " + DateTime.Now.ToString());
                
            }

        }

    }
}
