﻿using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace IPC_test_revit_plugin
{

    [Transaction(TransactionMode.Manual)]
    [Regeneration(RegenerationOption.Manual)]
    public class CommandClass : IExternalCommand
    {
        
        public Result Execute(ExternalCommandData commandData, ref string message, ElementSet elements)
        {

            // if the browser window/process is already open, activate it instead of opening a new process 
            if (MessageHandler.browser_pid != 0)
            {
                // the following line could be enough, but rather activate the window thru the process
                //SetForegroundWindow(MessageHandler.browser_hwnd);

                // try to activate the existing instance
                Process[] processes = Process.GetProcesses();
                
                foreach (Process p in processes)
                {
                    if (p.Id == MessageHandler.browser_pid)
                    {
                        IntPtr windowHandle = p.MainWindowHandle;
                        SetForegroundWindow(windowHandle);
                        return Result.Succeeded;
                    }
                }
            }

            // execute the browser window process
            Process process = new Process();
            process.StartInfo.FileName = AssemblyDirectory + "\\..\\..\\IPC_test_browser_process\\bin\\IPC_test_browser_process.exe ";
            process.StartInfo.Arguments = ApplicationClass.messagehandler.Handle.ToString(); // pass the MessageHandler's window handle the the process as a command line argument
            process.Start();

            MessageHandler.browser_pid = process.Id; // grab the PID so we can kill the process if required;

            return Result.Succeeded;
        }

        [DllImport("user32.dll")]
        [return: MarshalAs(UnmanagedType.Bool)]
        static extern bool SetForegroundWindow(IntPtr hWnd);

        /// <summary>
        /// Gets the path to the folder where this files compiled code lies 
        /// </summary>
        public static string AssemblyDirectory
        {
            get { return System.IO.Path.GetDirectoryName(new System.Uri(System.Reflection.Assembly.GetExecutingAssembly().CodeBase).LocalPath); }
        }

    }
}
