#region Namespaces
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Diagnostics;

using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.Utility;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.Architecture;
using Autodesk.Revit.DB.Structure;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;
using BoundarySegment = Autodesk.Revit.DB.BoundarySegment;
using Autodesk.Revit.DB.Electrical;
#endregion

namespace RevitAddin1
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;
            View view = uidoc.ActiveView;

            Reference ref1 = uidoc.Selection.PickObject(ObjectType.Element, "pick an element");
            Element elem = doc.GetElement(ref1);
            ICollection<ElementId> the_list_of_the_joined = JoinGeometryUtils.GetJoinedElements(doc, elem);
            System.Windows.Forms.MessageBox.Show(the_list_of_the_joined.Count.ToString());
            uidoc.Selection.Elements.Clear();
            foreach (ElementId id in the_list_of_the_joined)
            {
                uidoc.Selection.Elements.Add(doc.GetElement(id));
            }

            using (Transaction t = new Transaction(doc,"test"))
            {
                t.Start();
                t.Commit();
            }

            return Result.Succeeded;
        }
    }
}
