#region Namespaces
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Diagnostics;

using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.Utility;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.Architecture;
using Autodesk.Revit.DB.Structure;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;
using BoundarySegment = Autodesk.Revit.DB.BoundarySegment;
using Autodesk.Revit.DB.Electrical;
#endregion

namespace RevitAddin1
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;
            View view = uidoc.ActiveView;

            Reference ref1 = uidoc.Selection.PickObject(ObjectType.Element, "pick an element");
            Element elem = doc.GetElement(ref1);
            FamilyInstance fi = elem as FamilyInstance;
            LocationCurve lc = fi.Location as LocationCurve;

            uidoc.Selection.Elements.Clear();
            // retrieve joined elements 
            ElementArray startarray = lc.get_ElementsAtJoin(0); // start
            foreach (Element elem1 in startarray)
            {
                uidoc.Selection.Elements.Add(elem1);
                System.Windows.Forms.MessageBox.Show(elem.GetType().FullName.ToString());
            }
            ElementArray endarray = lc.get_ElementsAtJoin(1); // end
            foreach (Element elem2 in endarray)
            {
                uidoc.Selection.Elements.Add(elem2);
                System.Windows.Forms.MessageBox.Show(elem.GetType().FullName.ToString());
            }

            using (Transaction t = new Transaction(doc,"test"))
            {
                t.Start();
                t.Commit();
            }

            return Result.Succeeded;
        }
    }
}
