#region Namespaces
using System;
using System.Drawing;
using System.Windows.Forms;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Windows;
using System.IO;
#endregion

namespace JtExternalCommandLister
{
  [Transaction( TransactionMode.Manual )]
  public class Command : IExternalCommand
  {
    /// <summary>
    /// Define the initial .NET assembly folder.
    /// </summary>
    const string _assembly_folder_name
      = "C:\\ProgramData\\Autodesk\\Revit\\Addins\\2014";

    /// <summary>
    /// Select a .NET assembly file in the given folder.
    /// </summary>
    /// <param name="folder">Initial folder.</param>
    /// <param name="filename">Selected filename on success.</param>
    /// <returns>Return true if a file was successfully selected.</returns>
    static bool FileSelect(
      string folder,
      out string filename )
    {
      OpenFileDialog dlg = new OpenFileDialog();
      dlg.Title = "Select .NET Assembly or Cancel to Exit";
      dlg.CheckFileExists = true;
      dlg.CheckPathExists = true;
      dlg.InitialDirectory = folder;
      dlg.Filter = ".NET Assembly DLL Files (*.dll)|*.dll";
      bool rc = ( DialogResult.OK == dlg.ShowDialog() );
      filename = dlg.FileName;
      return rc;
    }

    void DisplayExternalCommands(
      string filename,
      IWin32Window owner )
    {
      ExternalCommandLister lister
        = new ExternalCommandLister( filename );

      string[] a = lister.CommandClassnames;
      int n = a.Length;

      System.Windows.Forms.Form form
        = new System.Windows.Forms.Form();

      form.Size = new Size( 400, 150 );

      form.Text = string.Format(
        "{0} defines {1} external command{2}",
        lister.AssemblyFilename, n,
        ( 1 == n ? "" : "s" ) );

      form.FormBorderStyle
        = FormBorderStyle.SizableToolWindow;

      System.Windows.Forms.TextBox tb
        = new System.Windows.Forms.TextBox();

      tb.Dock = System.Windows.Forms.DockStyle.Fill;
      tb.Location = new System.Drawing.Point( 0, 0 );
      tb.Multiline = true;
      tb.TabIndex = 0;
      tb.WordWrap = false;
      tb.ReadOnly = true;
      tb.Text = string.Join( "\r\n",
        lister.CommandClassnames );

      form.Controls.Add( tb );
      form.ShowDialog( owner );
    }

    public Result Execute(
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      IWin32Window revit_window
        = new JtWindowHandle(
          ComponentManager.ApplicationWindow );

      string filename;

      while( FileSelect(
        _assembly_folder_name,
        out filename ) )
      {
        DisplayExternalCommands( filename,
          revit_window );
      }
      return Result.Succeeded;
    }
  }
}
