﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;
using Autodesk.Revit.UI;

namespace JtExternalCommandLister
{
  class ExternalCommandLister
  {
    string _assembly_filename;
    string[] _external_commmand_class_names;

    /// <summary>
    /// Display error message
    /// </summary>
    /// <param name="msg">Message to display</param>
    void ErrorMsg( string msg )
    {
      Debug.WriteLine( "External Command Lister: "
        + msg );

      TaskDialog.Show( "External Command Lister",
        msg );
    }

    public ExternalCommandLister(
      string assembly_filename )
    {
      _assembly_filename = assembly_filename;
      _external_commmand_class_names = null;

      if( !File.Exists( assembly_filename ) )
      {
        throw new ArgumentOutOfRangeException(
          "assembly_filename", "file not found" );
      }
      try
      {
        // No need to load the Revit API assemblies, 
        // because we are ourselves a Revit API add-in 
        // inside of Revit, so they are guaranteed to
        // be present.

        //Assembly revit = Assembly.LoadFrom( "C:/Program Files/Autodesk/Revit Architecture 2014/RevitAPI.dll" );
        //string root = "C:/Program Files/Autodesk Revit Architecture 2014/";
        //Assembly adWindows = Assembly.LoadFrom( root + "AdWindows.dll" );
        //Assembly uiFramework = Assembly.LoadFrom( root + "UIFramework.dll" );
        //Assembly revit = Assembly.LoadFrom( root + "RevitAPI.dll" );

        // Load the selected assembly into 
        // the current application domain:

        Assembly asm = Assembly.LoadFrom(
          assembly_filename );

        if( null == asm )
        {
          ErrorMsg( string.Format(
            "Unable to load assembly '{0}'",
            assembly_filename ) );
        }
        else
        {
          IEnumerable<Type> types = asm.GetTypes()
            .Where<Type>( t =>
              null != t.GetInterface(
                "IExternalCommand" ) );

          _external_commmand_class_names = types
            .Select<Type, string>( t => t.FullName )
            .ToArray();
        }
      }
      catch( Exception ex )
      {
        ErrorMsg( string.Format(
          "Exception '{0}' processing assembly '{1}'",
          ex.Message, assembly_filename ) );
      }
    }

    public string AssemblyFilename
    {
      get
      {
        return Path.GetFileName( _assembly_filename );
      }
    }

    public string[] CommandClassnames
    {
      get
      {
        return _external_commmand_class_names;
      }
    }
  }
}
