﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.Collections;
using System.Windows.Forms;

using Autodesk.Revit;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.ApplicationServices;


namespace LandXMLSurface
{
        [Autodesk.Revit.Attributes.Transaction(Autodesk.Revit.Attributes.TransactionMode.Automatic)]
        [Autodesk.Revit.Attributes.Regeneration(Autodesk.Revit.Attributes.RegenerationOption.Automatic)]
        public class Command : IExternalCommand
        {
            public Autodesk.Revit.UI.Result Execute(ExternalCommandData commandData,
                ref string message, Autodesk.Revit.DB.ElementSet elements)
            {
         
                Autodesk.Revit.ApplicationServices.Application app = commandData.Application.Application;
                Document activeDoc = app.ActiveDocument;
           
                ParseLandXMLFile();
                if (pntList.Count > 2)
                {
                    TopographySurface surface = activeDoc.Create.NewTopographySurface(pntList);

                }
                    return Autodesk.Revit.UI.Result.Succeeded;
            }
           
            private void ParseLandXMLFile()
            {
                XmlDocument xmlDoc = new XmlDocument();
                //xmlDoc.Load(@"C:\LandXMLfiles\Surface and alignments.xml");
                xmlDoc.Load(@"C:\LandXMLfiles\GSG_features_surfaces_with_volumes.xml");
                
                XmlNodeList Pnts = xmlDoc.GetElementsByTagName("Pnts");
                // could be used to build terrain by faces with i.e. mass object 
                //XmlNodeList Faces = xmlDoc.GetElementsByTagName("Faces");
                char[] separator = new char[] { ' ' };
                XYZ xyz = null;
                double x = 0;
                double y = 0;
                double z = 0;
                // could be used to build terrain by faces
                // point id is used to described faces in landxml files
                //int id = 0;
                //LandPoint landPoint = null;
                pntList = new List<Autodesk.Revit.DB.XYZ>();
                for (int k = 0; k < Pnts.Count; k++)
                {
                    for (int i = 0; i < Pnts[k].ChildNodes.Count; i++)
                    {
                        int j = 1;
                        foreach (string substring in Pnts[k].ChildNodes[i].InnerText.Split(separator))
                        {
                            switch (j)
                            {
                                case 1:
                                    x = Double.Parse(substring);
                                    break;
                                case 2:
                                    y = Double.Parse(substring);
                                    break;
                                case 3:
                                    z = Double.Parse(substring);
                                    break;
                                default:
                                    break;
                            }
                            j++;
                        }

                        // could be used to generate terrain using mass for example 
                        // in case off grid definition 
                        // id =  int.Parse( Pnts[0].ChildNodes[i].Attributes[0].Value); 
                        // landPoint = new LandPoint(x,y,z,id);
                        // parser.landPoints.Add(landPoint);
                        xyz = new XYZ(x, y, z);
                        pntList.Add(xyz);

                    }
                }
            }
  
            private List<Autodesk.Revit.DB.XYZ> pntList;

        }
    
}
