#region Namespaces
using System;
using System.Collections.Generic;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using System.Diagnostics;
using Autodesk.Revit.DB.Structure;
#endregion

namespace LoadAdsk
{
  [Transaction( TransactionMode.Manual )]
  public class Command : IExternalCommand
  {
    public Result Execute(
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      UIApplication uiapp = commandData.Application;
      UIDocument uidoc = uiapp.ActiveUIDocument;
      Application app = uiapp.Application;
      Document doc = uidoc.Document;

      Transaction t = null;

      try
      {
        const string filename = "C:/a/doc/revit/blog/src/LoadAdsk/Part1.adsk";

        // Load ADSK using LoadFamily does not work;
        // rc is false, and f is null:

        //t = new Transaction( doc );
        //t.Start( "Load Adsk" );
        //Family f = null;
        //bool rc = doc.LoadFamily( _filename, out f );
        //t.Commit();

        // Load ADSK using OpenDocumentFile:
        // It does successfully open the ADSK in the 
        // family editor but also displays an error:
        // "Attempted to read or write protected memory. 
        // This is often an indication that other memory 
        // is corrupt."
        // cf. C:\a\doc\revit\blog\src\LoadAdsk\error_openDocumentFile.png

        //Document adsk_doc = app.OpenDocumentFile( filename );

        // Load ADSK using OpenBuildingComponentDocument:

        Document adsk_doc 
          = app.OpenBuildingComponentDocument( filename );

        Debug.Print( 
          "Opened component document {0} with path '{1}'",
          adsk_doc.Title, adsk_doc.PathName );

        t = new Transaction( doc );
        t.Start( "Load ADSK component document" );
        Family f = adsk_doc.LoadFamily( doc );
        t.Commit();

        Debug.Print(
          "Loaded component family {0}",
          f.Name );

        FamilySymbol symbol = null;

        foreach( FamilySymbol s in f.Symbols )
        {
          symbol = s;
          break;
        }

        t.Start( "Place ADSK component document" );
        FamilyInstance i = doc.Create.NewFamilyInstance( 
          XYZ.Zero, symbol, StructuralType.NonStructural );
        t.Commit();

        Debug.Print(
          "Placed component family instance {0}",
          i.Name );

        return Result.Succeeded;
      }
      catch( Exception ex )
      {
        if( null != t ) { t.RollBack(); }
        message = ex.Message;
        return Result.Failed;
      }
    }
  }
}
