﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Autodesk;
using Autodesk.Revit;
using Autodesk.Revit.Elements;

namespace ObjRel
{
  public class Command : IExternalCommand
  {
    IExternalCommand.Result IExternalCommand.Execute(
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      Application app = commandData.Application;
      Document doc = app.ActiveDocument;

      Autodesk.Revit.Geometry.Options opt 
        = app.Create.NewGeometryOptions();

      BuiltInCategory bicPreviewLegendComponent 
        = BuiltInCategory.OST_PreviewLegendComponents;

      int iBic = ( int ) bicPreviewLegendComponent;

      try
      {
        // select all model elements:

        ElementSet a = app.Create.NewElementSet();

        ElementIterator it = app.ActiveDocument.Elements;

        // Iterate through each element in the model and 
        // check if it fulfils the following criteria which ensure that it
        // is a model element with visible graphics and represents a valid 
        // physical part in the building model. For more details refer to
        // http://thebuildingcoder.typepad.com/blog/2009/11/select-model-elements-2.html and 
        // http://thebuildingcoder.typepad.com/blog/2009/05/selecting-model-elements.html

        while( it.MoveNext() )
        {
          Element e = it.Current as Element;

          if( !( e is Symbol )
            && !( e is FamilyBase )
            && ( null != e.Category )
            && ( iBic != e.Category.Id.Value )
            && ( null != e.get_Geometry( opt ) ) )
          {
            a.Insert( e );
          }
        }

        // show the object relationship dialog

        Result res = new Result( a, app );
        res.ShowDialog();
      }
      catch( Exception ex )
      {
        message = ex.Message;
      }
      return IExternalCommand.Result.Failed;
    }
  }
}
