﻿Imports System
Imports System.Collections.Generic
Imports System.Linq
Imports System.Text

Imports Autodesk
Imports Autodesk.Revit
Imports Autodesk.Revit.Elements

Namespace ObjRel
    Public Class Command
        Implements IExternalCommand
        Private Function Execute(ByVal commandData As ExternalCommandData, ByRef message As String, ByVal elements As ElementSet) As IExternalCommand.Result Implements IExternalCommand.Execute
            Dim app As Application = commandData.Application
            Dim doc As Document = app.ActiveDocument

            Dim opt As Autodesk.Revit.Geometry.Options = app.Create.NewGeometryOptions()

            Dim bicPreviewLegendComponent As BuiltInCategory = BuiltInCategory.OST_PreviewLegendComponents

            Dim iBic As Integer = CInt(bicPreviewLegendComponent)

            Try
                ' select all model elements:

                Dim a As ElementSet = app.Create.NewElementSet()

                Dim it As ElementIterator = app.ActiveDocument.Elements

                ' Iterate through each element in the model and 
                ' check if it fulfils the following criteria which ensure that it
                ' is a model element with visible graphics and represents a valid 
                ' physical part in the building model. For more details refer to
                ' http://thebuildingcoder.typepad.com/blog/2009/11/select-model-elements-2.html and 
                ' http://thebuildingcoder.typepad.com/blog/2009/05/selecting-model-elements.html

                While it.MoveNext()
                    Dim e As Element = TryCast(it.Current, Element)



                    If Not (TypeOf e Is Symbol) AndAlso Not (TypeOf e Is FamilyBase) AndAlso (e.Category IsNot Nothing) AndAlso (iBic <> e.Category.Id.Value) AndAlso (e.Geometry(opt) IsNot Nothing) Then
                        a.Insert(e)
                    End If
                End While

                ' show the object relationship dialog

                Dim res As New Result(a, app)
                res.ShowDialog()
            Catch ex As Exception
                message = ex.Message
            End Try
            Return IExternalCommand.Result.Failed
        End Function
    End Class
End Namespace
