﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Linq
Imports System.Text
Imports System.Windows.Forms

Imports Autodesk
Imports Autodesk.Revit

Namespace ObjRel
    Partial Public Class Result
        Inherits Form
        Private _elems As ElementSet
        Private _displayedElems As ElementSet
        Private _app As Autodesk.Revit.Application
        Private rootNode As TreeNode

        ''' <summary>
        ''' Obtain dependency information of the given BIM element
        ''' by creating a transaction, using one of the overloads of the Delete method and
        ''' aborting the transaction to get the dependent element Ids. For more details
        ''' refer to http://thebuildingcoder.typepad.com/blog/2009/04/tag-association.html
        ''' </summary>
        Private Function GetDependentsElementIds(ByVal e As Element) As ElementIdSet
            Dim doc As Document = _app.ActiveDocument

            doc.BeginTransaction()

            Dim ids As ElementIdSet = doc.Delete(e)

            doc.AbortTransaction()

            Return ids
        End Function

        ''' <summary>
        ''' This recursive method creates the tree nodes 
        ''' based on dependent element ids. Each node 
        ''' displays its element name, category and id.
        ''' </summary>
        Private Sub DisplayNode(ByVal e As Element, ByVal node As TreeNode)
            Dim cat As String = If((e.Category Is Nothing), "<category unknown>", e.Category.Name)

            Dim label As String = String.Format("{0}: {1} {2}", e.Name, cat, e.Id.Value)

            Dim father As TreeNode = node.Nodes.Add(label)

            ' save element id to handle select event, 
            ' cf. treeView1_AfterSelect:

            father.ImageKey = e.Id.Value.ToString()

            Dim ids As ElementIdSet = GetDependentsElementIds(e)

            Try
                If ids IsNot Nothing AndAlso 1 < ids.Size Then
                    Dim doc As Document = _app.ActiveDocument

                    For Each id1 As ElementId In ids
                        Dim id As ElementId = id1
                        Dim e2 As Element = doc.Element(id)
                        If e2 IsNot Nothing Then
                            If Not e2.Id.Equals(e.Id) AndAlso Not _displayedElems.Contains(e2) Then
                                _displayedElems.Insert(e2)
                                DisplayNode(e2, father)
                            End If
                        End If
                    Next
                End If
            Catch ex As Exception
                MessageBox.Show(ex.Message.ToString())
            End Try
        End Sub

        ''' <summary>
        ''' Creates the tree node with the initial node,
        ''' populates it, and maintains a list of elements 
        ''' already included in the nodes to avoid duplication.
        ''' </summary>
        Private Sub CreateRelationships()
            rootNode = New TreeNode(_app.ActiveDocument.Title)
            Me.treeView1.Nodes.Add(rootNode)

            _displayedElems = New ElementSet()

            For Each e As Element In _elems
                If Not _displayedElems.Contains(e) Then
                    DisplayNode(e, rootNode)
                End If
            Next
        End Sub

        ''' <summary>
        ''' Initialise the dialog with all the valid values and parameters
        ''' and register the event handler on the treeview control.
        ''' </summary>
        Public Sub New(ByVal elems As ElementSet, ByVal app As Autodesk.Revit.Application)
            _elems = elems
            _app = app

            InitializeComponent()
            CreateRelationships()

            AddHandler treeView1.AfterSelect, AddressOf treeView1_AfterSelect
        End Sub

        ''' <summary>
        ''' Handles the selection of tree node by the end user. 
        ''' On selecting a particular node, this methods zooms to 
        ''' the element represented by the node in the model to 
        ''' show a visual cue to help identify it.
        ''' </summary>
        Private Sub treeView1_AfterSelect(ByVal sender As Object, ByVal e As TreeViewEventArgs)
            If e.Node.ImageKey.Length > 0 Then
                Dim intId As Integer = Convert.ToInt32(e.Node.ImageKey)
                Dim id As New ElementId()
                id.Value = intId
                Dim e2 As Element = _app.ActiveDocument.Element(id)

                _app.ActiveDocument.ShowElements(e2)
            End If
        End Sub

        ''' <summary>
        ''' Closes the dialog.
        ''' </summary>
        Private Sub btnClose_Click(ByVal sender As Object, ByVal e As EventArgs)
            Close()
        End Sub

        Private Sub Result_Load(ByVal sender As Object, ByVal e As EventArgs) Handles MyBase.Load

        End Sub
    End Class
End Namespace
