#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;
using Autodesk.Windows;
using Application = Autodesk.Revit.ApplicationServices.Application;
using Form = System.Windows.Forms.Form;
#endregion

namespace PickTwoPoints
{
  [Transaction( TransactionMode.ReadOnly )]
  public class Command : IExternalCommand
  {
    /// <summary>
    /// Return a string for a real number
    /// formatted to two decimal places.
    /// </summary>
    public static string RealString( double a )
    {
      return a.ToString( "0.##" );
    }

    /// <summary>
    /// Return a string for an XYZ point
    /// or vector with its coordinates
    /// formatted to two decimal places.
    /// </summary>
    public static string PointString( XYZ p )
    {
      return string.Format( "({0},{1},{2})",
        RealString( p.X ),
        RealString( p.Y ),
        RealString( p.Z ) );
    }

    Form DisplayModelessForm( IWin32Window owner )
    {
      System.Windows.Forms.Form form
        = new System.Windows.Forms.Form();
      form.Size = new Size( 300, 100 );
      form.Text = "Pick Two Points Modeless Form";
      form.Show( owner );
      return form;
    }

    public Result Execute(
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      IWin32Window revit_window
        = new JtWindowHandle(
          ComponentManager.ApplicationWindow );

      UIApplication uiapp = commandData.Application;
      UIDocument uidoc = uiapp.ActiveUIDocument;
      Selection sel = uidoc.Selection;

      using( Form form = DisplayModelessForm(
        revit_window ) )
      {
        form.Hide();

        try
        {
          XYZ p = sel.PickPoint( "Point 1" );

          XYZ q = sel.PickPoint( "Point 2" );

          Debug.Print( string.Format(
            "The two points you selected are {0} and {1}.",
            PointString( p ), PointString( q ) ) );
        }
        catch( Exception e )
        {
          Debug.Print( e.Message );
        }

        form.Show();
      }
      return Result.Succeeded;
    }
  }
}
