﻿<Transaction(TransactionMode.Manual)> _
Public Class CmdTest2012
  Implements IExternalCommand

  Public Function Execute( _
    ByVal commandData As ExternalCommandData, _
    ByRef message As String, _
    ByVal elements As ElementSet) As Result Implements IExternalCommand.Execute

    Dim uiapp As UIApplication = commandData.Application
    Dim app As Application = uiapp.Application
    Dim uidoc As UIDocument = uiapp.ActiveUIDocument
    Dim doc As Document = uidoc.Document
    Dim sel As Selection = uidoc.Selection

    Try
      Dim ref As Reference = sel.PickObject( _
        ObjectType.Face, "Select a face")

      Dim elem As Element = doc.GetElement(ref)

      Dim gObj As GeometryObject _
        = elem.GetGeometryObjectFromReference(ref)

      Dim face As PlanarFace = TryCast(gObj, PlanarFace)

      If face Is Nothing Then
        MsgBox("Not a planar face")
      End If

      Dim v As ViewDrafting = Nothing

      Dim tr As New Transaction(doc, "Draw Face")
      tr.Start()

      Try
        v = doc.Create.NewViewDrafting 'create a new view
        v.Scale = 48 '1/4" = 1'-0"

        'this transform re-orients the global 
        'coordinate system to the face's coordinate system
        Dim trans As Transform _
          = Util.PlanarFaceTransform(face)

        For Each eArr As EdgeArray In face.EdgeLoops
          For Each e As Edge In eArr
            Dim c As Curve = e.AsCurveFollowingFace(face)
            c = c.Transformed(trans) 'orient the curve on the XY plane
            doc.Create.NewDetailCurve(v, c) 'draw the curve
          Next
        Next

        tr.Commit()
      Catch ex As Exception
        tr.RollBack()
        MsgBox("Error: " + ex.Message)
      End Try

      If tr.GetStatus = TransactionStatus.Committed Then
        uidoc.ActiveView = v
      End If

    Catch ex As Exception
      MsgBox("Error: " + ex.Message)
    End Try

    Return Result.Succeeded

  End Function
End Class
